/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.SelectionList;
import org.apache.cocoon.forms.datatype.SelectionListBuilder;
import org.apache.cocoon.forms.datatype.convertor.ConversionResult;
import org.apache.cocoon.forms.event.ValueChangedListener;
import org.apache.cocoon.forms.formmodel.AbstractDatatypeWidgetDefinition;
import org.apache.cocoon.forms.formmodel.AbstractWidgetDefinitionBuilder;
import org.apache.cocoon.forms.formmodel.WidgetDefinitionBuilderContext;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.i18n.I18nUtils;
import org.apache.cocoon.processing.ProcessInfoProvider;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xmlizer.XMLizer;
import org.w3c.dom.Element;

public abstract class AbstractDatatypeWidgetDefinitionBuilder
extends AbstractWidgetDefinitionBuilder {
    private Map selectionListBuilders;
    private String defaultSelectionListBuilder;
    private XMLizer xmlizer;
    private SourceResolver sourceResolver;
    private ProcessInfoProvider processInfoProvider;

    protected void setupDefinition(Element widgetElement, AbstractDatatypeWidgetDefinition definition, WidgetDefinitionBuilderContext context) throws Exception {
        this.setupDefinition(widgetElement, definition, context, false);
    }

    protected void setupDefinition(Element widgetElement, AbstractDatatypeWidgetDefinition definition, WidgetDefinitionBuilderContext context, boolean isArrayType) throws Exception {
        definition.setProcessInfoProvider(this.processInfoProvider);
        definition.setSourceResolver(this.sourceResolver);
        definition.setXmlizer(this.xmlizer);
        super.setupDefinition(widgetElement, definition, context);
        this.setDisplayData(widgetElement, definition);
        Iterator i = this.buildEventListeners(widgetElement, "on-value-changed", ValueChangedListener.class).iterator();
        while (i.hasNext()) {
            definition.addValueChangedListener((ValueChangedListener)i.next());
        }
        Element datatypeElement = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", "datatype");
        if (datatypeElement != null) {
            Datatype datatype = this.datatypeManager.createDatatype(datatypeElement, isArrayType);
            Object initialValue = null;
            Element initialValueElement = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", "initial-value", false);
            if (initialValueElement != null) {
                String localeValue = DomHelper.getAttribute(initialValueElement, "locale", null);
                Locale locale = localeValue == null ? Locale.getDefault() : I18nUtils.parseLocale((String)localeValue);
                String value = DomHelper.getElementText(initialValueElement);
                ConversionResult result = datatype.convertFromString(value, locale);
                if (!result.isSuccessful()) {
                    throw new FormsException("Cannot parse initial value '" + value + "'.", DomHelper.getLocationObject(initialValueElement));
                }
                initialValue = result.getResult();
            }
            definition.setDatatype(datatype, initialValue);
        }
        definition.checkMutable();
        SelectionList list = this.buildSelectionList(widgetElement, definition, "selection-list");
        if (list != null) {
            definition.setSelectionList(list);
        }
    }

    protected SelectionList buildSelectionList(Element widgetElement, AbstractDatatypeWidgetDefinition definition, String name) throws Exception {
        SelectionListBuilder builder;
        Element selectionListElement = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", name);
        if (selectionListElement != null && definition.getDatatype() == null) {
            throw new FormsException("A widget with a selection list requires a datatype.", DomHelper.getLocationObject(widgetElement));
        }
        if (selectionListElement == null) {
            return null;
        }
        String listType = selectionListElement.getAttribute("type");
        if ("".equals(listType)) {
            listType = this.defaultSelectionListBuilder;
        }
        if ((builder = (SelectionListBuilder)this.selectionListBuilders.get(listType)) == null) {
            throw new FormsException("Unknown selection list builder: " + listType);
        }
        return builder.build(selectionListElement, definition.getDatatype());
    }

    public void setSelectionListBuilders(Map selectionListBuilders) {
        this.selectionListBuilders = selectionListBuilders;
    }

    public void setXmlizer(XMLizer xmlizer) {
        this.xmlizer = xmlizer;
    }

    public void setSourceResolver(SourceResolver sourceResolver) {
        this.sourceResolver = sourceResolver;
    }

    public void setProcessInfoProvider(ProcessInfoProvider processInfoProvider) {
        this.processInfoProvider = processInfoProvider;
    }

    protected ProcessInfoProvider getProcessInfoProvider() {
        return this.processInfoProvider;
    }

    public void setDefaultSelectionListBuilder(String defaultSelectionListBuilder) {
        this.defaultSelectionListBuilder = defaultSelectionListBuilder;
    }
}

