/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype.convertor;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.cocoon.forms.datatype.convertor.ConversionResult;
import org.apache.cocoon.forms.datatype.convertor.Convertor;
import org.apache.cocoon.forms.datatype.convertor.FormattingDecimalConvertor;

public class FormattingFloatConvertor
extends FormattingDecimalConvertor {
    public ConversionResult convertFromString(String value, Locale locale, Convertor.FormatCache formatCache) {
        value = value.replace(' ', '\u00a0');
        DecimalFormat decimalFormat = this.getDecimalFormat(locale, formatCache);
        try {
            Number decimalValue = decimalFormat.parse(value);
            if (decimalValue instanceof Float) {
                return new ConversionResult(decimalValue);
            }
            return new ConversionResult(new Float(decimalValue.floatValue()));
        }
        catch (ParseException e) {
            return ConversionResult.create("float");
        }
    }

    public Class getTypeClass() {
        return Float.class;
    }
}

