/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.SelectionList;
import org.apache.cocoon.forms.datatype.convertor.Convertor;
import org.apache.cocoon.forms.datatype.convertor.DefaultFormatCache;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class StaticSelectionList
implements SelectionList {
    private Datatype datatype;
    private List items;

    public StaticSelectionList(Datatype datatype) {
        this.datatype = datatype;
        this.items = new ArrayList();
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public void generateSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        DefaultFormatCache formatCache = new DefaultFormatCache();
        contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "selection-list", "fi:selection-list", XMLUtils.EMPTY_ATTRIBUTES);
        Iterator itemIt = this.items.iterator();
        while (itemIt.hasNext()) {
            SelectionListItem item = (SelectionListItem)itemIt.next();
            item.generateSaxFragment(contentHandler, locale, formatCache);
        }
        contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "selection-list", "fi:selection-list");
    }

    public List getItems() {
        return this.items;
    }

    public void addItem(Object value, XMLizable label) {
        this.items.add(new SelectionListItem(value, label));
    }

    public void addItem(Object value, String label) {
        this.items.add(new SelectionListItem(value, label));
    }

    public void addItem(Object value) {
        this.items.add(new SelectionListItem(value));
    }

    public final class SelectionListItem {
        private final Object value;
        private final Object label;

        public SelectionListItem(Object value, XMLizable label) {
            this.value = value;
            this.label = label;
        }

        public SelectionListItem(Object value, String label) {
            this.value = value;
            this.label = label;
        }

        public SelectionListItem(Object value) {
            this.value = value;
            this.label = null;
        }

        public Object getValue() {
            return this.value;
        }

        public void generateSaxFragment(ContentHandler contentHandler, Locale locale, Convertor.FormatCache formatCache) throws SAXException {
            String stringValue = this.value != null ? StaticSelectionList.this.getDatatype().getConvertor().convertToString(this.value, locale, formatCache) : "";
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("value", stringValue);
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "item", "fi:item", (Attributes)attrs);
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "label", "fi:label", XMLUtils.EMPTY_ATTRIBUTES);
            if (this.label == null) {
                contentHandler.characters(stringValue.toCharArray(), 0, stringValue.length());
            } else if (this.label instanceof XMLizable) {
                ((XMLizable)this.label).toSAX(contentHandler);
            } else {
                String stringLabel = (String)this.label;
                contentHandler.characters(stringLabel.toCharArray(), 0, stringLabel.length());
            }
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "label", "fi:label");
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "item", "fi:item");
        }
    }
}

