/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype;

import java.util.Map;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.FlowJXPathSelectionList;
import org.apache.cocoon.forms.datatype.SelectionList;
import org.apache.cocoon.forms.datatype.SelectionListBuilder;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.processing.ProcessInfoProvider;
import org.w3c.dom.Element;

public class FlowJXPathSelectionListBuilder
implements SelectionListBuilder {
    private ProcessInfoProvider processInfoProvider;

    public SelectionList build(Element selectionListElement, Datatype datatype) throws Exception {
        String listPath = DomHelper.getAttribute(selectionListElement, "list-path");
        String valuePath = DomHelper.getAttribute(selectionListElement, "value-path");
        Map nspfx = DomHelper.getInheritedNSDeclarations(selectionListElement);
        String i18nPfx = "i18n";
        if (nspfx != null && (i18nPfx = (String)nspfx.get("http://apache.org/cocoon/i18n/2.1")) == null) {
            i18nPfx = "i18n";
        }
        String labelPath = DomHelper.getAttribute(selectionListElement, "label-path", null);
        boolean labelIsI18nKey = false;
        if (labelPath == null) {
            labelPath = DomHelper.getAttribute(selectionListElement, i18nPfx + ":label-path");
            labelIsI18nKey = true;
        }
        String nullText = DomHelper.getAttribute(selectionListElement, "null-text", null);
        boolean nullTextIsI18nKey = false;
        if (nullText == null && (nullText = DomHelper.getAttribute(selectionListElement, i18nPfx + ":null-text", null)) != null) {
            nullTextIsI18nKey = true;
        }
        String i18nCatalog = DomHelper.getAttribute(selectionListElement, "catalogue", null);
        return new FlowJXPathSelectionList(this.processInfoProvider, listPath, valuePath, labelPath, datatype, nullText, nullTextIsI18nKey, i18nCatalog, labelIsI18nKey);
    }

    public void setProcessInfoProvider(ProcessInfoProvider processInfoProvider) {
        this.processInfoProvider = processInfoProvider;
    }
}

