/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Locale;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.SelectionList;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.enums.Enum;
import org.apache.commons.lang.enums.EnumUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class EnumSelectionList
implements SelectionList {
    public static final String TEXT_EL = "text";
    private Datatype datatype;
    private Class clazz;
    private boolean nullable;
    private String nullText;

    public EnumSelectionList(String className, Datatype datatype, boolean nullable) throws ClassNotFoundException {
        this.datatype = datatype;
        this.nullable = nullable;
        this.clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
    }

    public EnumSelectionList(String className, Datatype datatype, boolean nullable, String nullText) throws ClassNotFoundException {
        this(className, datatype, nullable);
        this.nullText = nullText;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public void generateSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        try {
            Iterator iter;
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "selection-list", "fi:selection-list", XMLUtils.EMPTY_ATTRIBUTES);
            if (this.nullable) {
                AttributesImpl voidAttrs = new AttributesImpl();
                voidAttrs.addCDATAAttribute("value", "");
                contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "item", "fi:item", (Attributes)voidAttrs);
                if (this.nullText != null) {
                    contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "label", "fi:label", XMLUtils.EMPTY_ATTRIBUTES);
                    contentHandler.startElement("http://apache.org/cocoon/i18n/2.1", TEXT_EL, "i18n:text", XMLUtils.EMPTY_ATTRIBUTES);
                    contentHandler.characters(this.nullText.toCharArray(), 0, this.nullText.length());
                    contentHandler.endElement("http://apache.org/cocoon/i18n/2.1", TEXT_EL, "i18n:text");
                    contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "label", "fi:label");
                }
                contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "item", "fi:item");
            }
            boolean apacheEnumDone = false;
            if (Enum.class.isAssignableFrom(this.clazz) && (iter = EnumUtils.iterator((Class)this.clazz)) != null) {
                apacheEnumDone = true;
                while (iter.hasNext()) {
                    Enum element = (Enum)iter.next();
                    String stringValue = this.clazz.getName() + "." + element.getName();
                    this.generateItem(contentHandler, stringValue);
                }
            }
            if (!apacheEnumDone) {
                Field[] fields = this.clazz.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    int mods = fields[i].getModifiers();
                    if (!Modifier.isPublic(mods) || !Modifier.isStatic(mods) || !Modifier.isFinal(mods) || !fields[i].get(null).getClass().equals(this.clazz)) continue;
                    String stringValue = this.clazz.getName() + "." + fields[i].getName();
                    this.generateItem(contentHandler, stringValue);
                }
            }
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "selection-list", "fi:selection-list");
        }
        catch (Exception e) {
            throw new SAXException("Got exception trying to get enum's values", e);
        }
    }

    private void generateItem(ContentHandler contentHandler, String stringValue) throws SAXException {
        AttributesImpl itemAttrs = new AttributesImpl();
        itemAttrs.addCDATAAttribute("value", stringValue);
        contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "item", "fi:item", (Attributes)itemAttrs);
        contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "label", "fi:label", XMLUtils.EMPTY_ATTRIBUTES);
        contentHandler.startElement("http://apache.org/cocoon/i18n/2.1", TEXT_EL, "i18n:text", XMLUtils.EMPTY_ATTRIBUTES);
        contentHandler.characters(stringValue.toCharArray(), 0, stringValue.length());
        contentHandler.endElement("http://apache.org/cocoon/i18n/2.1", TEXT_EL, "i18n:text");
        contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "label", "fi:label");
        contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "item", "fi:item");
    }
}

