/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype;

import java.util.Locale;
import org.apache.cocoon.core.xml.SAXParser;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.DynamicSelectionList;
import org.apache.cocoon.forms.datatype.SelectionList;
import org.apache.cocoon.forms.datatype.SelectionListBuilder;
import org.apache.cocoon.forms.datatype.StaticSelectionList;
import org.apache.cocoon.forms.datatype.convertor.ConversionResult;
import org.apache.cocoon.forms.datatype.convertor.Convertor;
import org.apache.cocoon.forms.datatype.convertor.DefaultFormatCache;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.processing.ProcessInfoProvider;
import org.apache.cocoon.util.Deprecation;
import org.apache.cocoon.util.location.LocationAttributes;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.sax.XMLizable;
import org.apache.excalibur.xmlizer.XMLizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultSelectionListBuilder
implements SelectionListBuilder {
    private SourceResolver sourceResolver;
    private XMLizer xmlizer;
    private ProcessInfoProvider processInfoProvider;
    private SAXParser parser;

    public SelectionList build(Element selectionListElement, Datatype datatype) throws Exception {
        SelectionList selectionList;
        String src = selectionListElement.getAttribute("src");
        if (src.length() > 0) {
            boolean dynamic = true;
            boolean usePerRequestCache = false;
            String cacheType = DomHelper.getAttribute(selectionListElement, "cache", null);
            if ("request".equals(cacheType)) {
                dynamic = true;
                usePerRequestCache = true;
            } else if ("none".equals(cacheType)) {
                dynamic = true;
            } else if ("static".equals(cacheType)) {
                dynamic = false;
            } else if (DomHelper.getAttribute(selectionListElement, "dynamic", null) != null) {
                Deprecation.logger.warn((Object)("'@dynamic' is deprecated in <fd:selection-list> and replaced by '@cache' at " + DomHelper.getLocation(selectionListElement)));
                dynamic = DomHelper.getAttributeAsBoolean(selectionListElement, "dynamic", false);
            }
            if (dynamic) {
                selectionList = new DynamicSelectionList(datatype, src, usePerRequestCache, this.xmlizer, this.sourceResolver, this.processInfoProvider.getRequest());
            } else {
                selectionListElement = this.readSelectionList(src);
                selectionList = this.buildStaticList(selectionListElement, datatype);
            }
        } else {
            selectionList = this.buildStaticList(selectionListElement, datatype);
        }
        return selectionList;
    }

    private SelectionList buildStaticList(Element selectionListElement, Datatype datatype) throws Exception {
        StaticSelectionList selectionList = new StaticSelectionList(datatype);
        Convertor convertor = null;
        DefaultFormatCache formatCache = new DefaultFormatCache();
        LocationAttributes.remove((Element)selectionListElement, (boolean)true);
        NodeList children = selectionListElement.getChildNodes();
        int i = 0;
        while (children.item(i) != null) {
            Node node = children.item(i);
            if (convertor == null && node instanceof Element && "http://apache.org/cocoon/forms/1.0#definition".equals(node.getNamespaceURI()) && "convertor".equals(node.getLocalName())) {
                Element convertorConfigElement = (Element)node;
                try {
                    convertor = datatype.getBuilder().buildConvertor(convertorConfigElement);
                }
                catch (Exception e) {
                    throw new SAXException("Error building convertor from convertor configuration embedded in selection list XML.", e);
                }
            } else if (node instanceof Element && "http://apache.org/cocoon/forms/1.0#definition".equals(node.getNamespaceURI()) && "item".equals(node.getLocalName())) {
                Object value;
                Element element;
                String stringValue;
                if (convertor == null) {
                    convertor = datatype.getConvertor();
                }
                if ("".equals(stringValue = (element = (Element)node).getAttribute("value"))) {
                    value = null;
                } else {
                    ConversionResult conversionResult = convertor.convertFromString(stringValue, Locale.US, formatCache);
                    if (!conversionResult.isSuccessful()) {
                        throw new Exception("Could not convert the value \"" + stringValue + "\" to the type " + datatype.getDescriptiveName() + ", defined at " + DomHelper.getLocation(element));
                    }
                    value = conversionResult.getResult();
                }
                XMLizable label = null;
                Element labelEl = DomHelper.getChildElement(element, "http://apache.org/cocoon/forms/1.0#definition", "label");
                if (labelEl != null) {
                    label = DomHelper.compileElementContent(labelEl);
                }
                selectionList.addItem(value, label);
            }
            ++i;
        }
        return selectionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element readSelectionList(String src) throws Exception {
        Element element;
        block3: {
            Source source = null;
            try {
                source = this.sourceResolver.resolveURI(src);
                InputSource inputSource = new InputSource(source.getInputStream());
                inputSource.setSystemId(source.getURI());
                Document document = DomHelper.parse(inputSource, this.parser);
                Element selectionListElement = document.getDocumentElement();
                if (!"http://apache.org/cocoon/forms/1.0#definition".equals(selectionListElement.getNamespaceURI()) || !"selection-list".equals(selectionListElement.getLocalName())) {
                    throw new Exception("Expected a fd:selection-list element at " + DomHelper.getLocation(selectionListElement));
                }
                element = selectionListElement;
                Object var8_7 = null;
                if (source == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var8_8 = null;
                    if (source == null) break block4;
                    this.sourceResolver.release(source);
                }
                throw throwable;
            }
            this.sourceResolver.release(source);
        }
        return element;
    }

    public void setSourceResolver(SourceResolver sourceResolver) {
        this.sourceResolver = sourceResolver;
    }

    public void setXmlizer(XMLizer xmlizer) {
        this.xmlizer = xmlizer;
    }

    public void setProcessInfoProvider(ProcessInfoProvider processInfoProvider) {
        this.processInfoProvider = processInfoProvider;
    }

    public void setParser(SAXParser parser) {
        this.parser = parser;
    }
}

