/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import java.util.Iterator;
import java.util.Map;
import org.apache.cocoon.components.flow.javascript.ScriptableMap;
import org.apache.cocoon.forms.binding.Binding;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.util.JavaScriptHelper;
import org.apache.cocoon.processing.ProcessInfoProvider;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class JavaScriptJXPathBinding
extends JXPathBindingBase {
    static final String[] LOAD_PARAMS = new String[]{"widget", "jxpathPointer", "jxpathContext", "childBindings"};
    static final String[] SAVE_PARAMS = new String[]{"widget", "jxpathPointer", "jxpathContext", "childBindings"};
    private final String id;
    private final String path;
    private final Function loadScript;
    private final Function saveScript;
    private final Scriptable childBindings;
    private final Map childBindingsMap;
    private ProcessInfoProvider processInfoProvider;

    public JavaScriptJXPathBinding(ProcessInfoProvider processInfoProvider, JXPathBindingBuilderBase.CommonAttributes commonAtts, String id, String path, Function loadScript, Function saveScript, Map childBindings) {
        super(commonAtts);
        this.id = id;
        this.path = path;
        this.loadScript = loadScript;
        this.saveScript = saveScript;
        this.processInfoProvider = processInfoProvider;
        Iterator i = childBindings.values().iterator();
        while (i.hasNext()) {
            ((Binding)i.next()).setParent(this);
        }
        this.childBindingsMap = childBindings;
        this.childBindings = new ScriptableMap(childBindings);
    }

    public String getPath() {
        return this.path;
    }

    public String getId() {
        return this.id;
    }

    public Function getLoadScript() {
        return this.loadScript;
    }

    public Function getSaveScript() {
        return this.saveScript;
    }

    public Map getChildBindingsMap() {
        return this.childBindingsMap;
    }

    public void doLoad(Widget frmModel, JXPathContext jctx) {
        if (this.loadScript != null) {
            Widget widget = this.selectWidget(frmModel, this.id);
            Pointer pointer = jctx.getPointer(this.path);
            Map objectModel = this.processInfoProvider.getObjectModel();
            try {
                JXPathContext newCtx = pointer.getNode() == null ? null : jctx.getRelativeContext(pointer);
                JavaScriptHelper.callFunction(this.loadScript, widget, new Object[]{widget, pointer, newCtx, this.childBindings}, objectModel);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking JavaScript event handler", e);
            }
        } else if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info((Object)("[Javascript Binding] - loadForm: No javascript code available. Widget id=" + this.getId()));
        }
    }

    public void doSave(Widget frmModel, JXPathContext jctx) throws BindingException {
        if (this.saveScript != null) {
            Widget widget = this.selectWidget(frmModel, this.id);
            Pointer pointer = jctx.createPath(this.path);
            JXPathContext widgetCtx = jctx.getRelativeContext(pointer);
            try {
                Map objectModel = this.processInfoProvider.getObjectModel();
                JavaScriptHelper.callFunction(this.saveScript, widget, new Object[]{widget, pointer, widgetCtx, this.childBindings}, objectModel);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking JavaScript event handler", e);
            }
        } else if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info((Object)("[Javascript Binding] - saveForm: No code available on the javascript binding with id '" + this.getId() + "'"));
        }
    }
}

