/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;
import org.apache.cocoon.core.xml.SAXParser;
import org.apache.cocoon.forms.CacheManager;
import org.apache.cocoon.forms.binding.Binding;
import org.apache.cocoon.forms.binding.BindingBuilderContext;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.BindingManager;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBuilder;
import org.apache.cocoon.forms.binding.library.Library;
import org.apache.cocoon.forms.binding.library.LibraryException;
import org.apache.cocoon.forms.binding.library.LibraryManager;
import org.apache.cocoon.forms.binding.library.LibraryManagerImpl;
import org.apache.cocoon.forms.datatype.DatatypeManager;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.util.location.LocationAttributes;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class JXPathBindingManager
implements BindingManager {
    private static Log LOG = LogFactory.getLog((Class)JXPathBindingManager.class);
    private static final String PREFIX = "CocoonFormBinding:";
    protected DatatypeManager datatypeManager;
    protected Map bindingBuilders;
    private CacheManager cacheManager;
    protected LibraryManagerImpl libraryManager;
    private SourceResolver sourceResolver;
    private SAXParser parser;

    public Binding createBinding(Source source) throws BindingException {
        Binding binding = (Binding)this.cacheManager.get(source, PREFIX);
        if (binding != null && !binding.isValid()) {
            binding = null;
        }
        if (binding == null) {
            try {
                InputSource is = new InputSource(source.getInputStream());
                is.setSystemId(source.getURI());
                Document doc = DomHelper.parse(is, this.parser);
                binding = this.createBinding(doc.getDocumentElement());
                this.cacheManager.set(binding, source, PREFIX);
            }
            catch (BindingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BindingException("Error creating binding from " + source.getURI(), e);
            }
        }
        return binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Binding createBinding(String bindingURI) throws BindingException {
        Binding binding;
        block4: {
            Source source = null;
            try {
                try {
                    source = this.sourceResolver.resolveURI(bindingURI);
                }
                catch (Exception e) {
                    throw new BindingException("Error resolving binding source: " + bindingURI);
                }
                binding = this.createBinding(source);
                Object var5_5 = null;
                if (source == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var5_6 = null;
                    if (source == null) break block5;
                    this.sourceResolver.release(source);
                }
                throw throwable;
            }
            this.sourceResolver.release(source);
        }
        return binding;
    }

    public Binding createBinding(Element bindingElement) throws BindingException {
        JXPathBindingBase binding = null;
        if ("http://apache.org/cocoon/forms/1.0#binding".equals(bindingElement.getNamespaceURI())) {
            binding = this.getBuilderAssistant().getBindingForConfigurationElement(bindingElement);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creation of new binding finished. " + binding));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Root Element of said binding file is in wrong namespace.");
        }
        return binding;
    }

    public Assistant getBuilderAssistant() {
        return new Assistant();
    }

    public void setDatatypeManager(DatatypeManager datatypeManager) {
        this.datatypeManager = datatypeManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setBindingBuilders(Map bindingBuilders) {
        this.bindingBuilders = bindingBuilders;
    }

    public void setParser(SAXParser parser) {
        this.parser = parser;
    }

    public void setLibraryManager(LibraryManagerImpl libraryManager) {
        this.libraryManager = libraryManager;
    }

    public void setSourceResolver(SourceResolver sourceResolver) {
        this.sourceResolver = sourceResolver;
    }

    public class Assistant {
        private BindingBuilderContext context = new BindingBuilderContext();
        private Stack contextStack = new Stack();

        private JXPathBindingBuilder getBindingBuilder(String bindingType) throws BindingException {
            JXPathBindingBuilder builder = (JXPathBindingBuilder)JXPathBindingManager.this.bindingBuilders.get(bindingType);
            if (builder == null) {
                throw new BindingException("Cannot handle binding element '" + bindingType + "'.");
            }
            return builder;
        }

        public JXPathBindingBase getBindingForConfigurationElement(Element configElm) throws BindingException {
            String bindingType = configElm.getLocalName();
            JXPathBindingBuilder bindingBuilder = this.getBindingBuilder(bindingType);
            boolean flag = false;
            if (this.context.getLocalLibrary() == null) {
                Library lib = new Library(JXPathBindingManager.this.libraryManager, JXPathBindingManager.this.getBuilderAssistant());
                this.context.setLocalLibrary(lib);
                lib.setSourceURI(LocationAttributes.getURI((Element)configElm));
                flag = true;
            }
            if (this.context.getLocalLibrary() != null && configElm.hasAttribute("extends")) {
                try {
                    this.context.setSuperBinding(this.context.getLocalLibrary().getBinding(configElm.getAttribute("extends")));
                }
                catch (LibraryException e) {
                    throw new NestableRuntimeException("Error extending binding! (at " + DomHelper.getLocation(configElm) + ")", (Throwable)((Object)e));
                }
            } else {
                this.context.setSuperBinding(null);
            }
            JXPathBindingBase childBinding = bindingBuilder.buildBinding(configElm, this);
            if (flag && childBinding != null) {
                childBinding.setEnclosingLibrary(this.context.getLocalLibrary());
            }
            return childBinding;
        }

        private JXPathBindingBase[] mergeBindings(JXPathBindingBase[] existing, JXPathBindingBase[] extra) {
            int i;
            if (existing == null || existing.length == 0) {
                return extra;
            }
            if (extra == null || extra.length == 0) {
                return existing;
            }
            ArrayList<JXPathBindingBase> list = new ArrayList<JXPathBindingBase>(existing.length);
            for (i = 0; i < existing.length; ++i) {
                list.add(existing[i]);
            }
            for (i = 0; i < extra.length; ++i) {
                if (extra[i].getId() == null) {
                    list.add(extra[i]);
                    continue;
                }
                boolean match = false;
                for (int j = 0; j < list.size(); ++j) {
                    if (!extra[i].getId().equals(((JXPathBindingBase)list.get(j)).getId())) continue;
                    list.set(j, extra[i]);
                    match = true;
                    break;
                }
                if (match) continue;
                list.add(extra[i]);
            }
            return list.toArray(new JXPathBindingBase[list.size()]);
        }

        public JXPathBindingBase[] makeChildBindings(Element parentElement) throws BindingException {
            return this.makeChildBindings(parentElement, new JXPathBindingBase[0]);
        }

        public JXPathBindingBase[] makeChildBindings(Element parentElement, JXPathBindingBase[] existingBindings) throws BindingException {
            Element[] childElements;
            if (existingBindings == null) {
                existingBindings = new JXPathBindingBase[]{};
            }
            if (parentElement != null && (childElements = DomHelper.getChildElements(parentElement, "http://apache.org/cocoon/forms/1.0#binding")).length > 0) {
                JXPathBindingBase[] childBindings = new JXPathBindingBase[childElements.length];
                for (int i = 0; i < childElements.length; ++i) {
                    this.pushContext();
                    this.context.setSuperBinding(null);
                    String id = DomHelper.getAttribute(childElements[i], "id", null);
                    String path = DomHelper.getAttribute(childElements[i], "path", null);
                    if (this.context.getLocalLibrary() != null && childElements[i].getAttribute("extends") != null) {
                        try {
                            this.context.setSuperBinding(this.context.getLocalLibrary().getBinding(childElements[i].getAttribute("extends")));
                            if (this.context.getSuperBinding() == null) {
                                this.context.setSuperBinding(this.getBindingByIdOrPath(id, path, existingBindings));
                            }
                        }
                        catch (LibraryException e) {
                            throw new BindingException("Error extending binding! (at " + DomHelper.getLocation(childElements[i]) + ")", (Throwable)((Object)e));
                        }
                    }
                    childBindings[i] = this.getBindingForConfigurationElement(childElements[i]);
                    this.popContext();
                }
                return this.mergeBindings(existingBindings, childBindings);
            }
            return existingBindings;
        }

        private JXPathBindingBase getBindingByIdOrPath(String id, String path, JXPathBindingBase[] bindings) {
            String name = id;
            if (name == null) {
                name = "Context:" + path;
            }
            for (int i = 0; i < bindings.length; ++i) {
                if (!name.equals(bindings[i].getId())) continue;
                return bindings[i];
            }
            return null;
        }

        public DatatypeManager getDatatypeManager() {
            return JXPathBindingManager.this.datatypeManager;
        }

        public LibraryManager getLibraryManager() {
            return JXPathBindingManager.this.libraryManager;
        }

        public BindingBuilderContext getContext() {
            return this.context;
        }

        private void pushContext() {
            BindingBuilderContext c = new BindingBuilderContext(this.context);
            this.contextStack.push(this.context);
            this.context = c;
        }

        private void popContext() {
            this.context = !this.contextStack.empty() ? (BindingBuilderContext)this.contextStack.pop() : new BindingBuilderContext();
        }
    }
}

