/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.validation.impl;

import java.util.Map;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.util.JavaScriptHelper;
import org.apache.cocoon.forms.validation.ValidationError;
import org.apache.cocoon.forms.validation.ValidationErrorAware;
import org.apache.cocoon.forms.validation.WidgetValidator;
import org.apache.cocoon.processing.ProcessInfoProvider;
import org.apache.excalibur.xml.sax.XMLizable;
import org.mozilla.javascript.Function;

public class JavaScriptValidator
implements WidgetValidator {
    private final Function function;
    private final ProcessInfoProvider processInfoProvider;

    public JavaScriptValidator(ProcessInfoProvider processInfoProvider, Function function) {
        this.function = function;
        this.processInfoProvider = processInfoProvider;
    }

    public final boolean validate(Widget widget) {
        Object result;
        Map objectModel = this.processInfoProvider.getObjectModel();
        try {
            result = JavaScriptHelper.callFunction(this.function, widget, new Object[]{widget}, objectModel);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Error invoking JavaScript event handler", e);
        }
        if (result == null) {
            throw new RuntimeException("Validation script did not return a value");
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result instanceof ValidationError) {
            ((ValidationErrorAware)((Object)widget)).setValidationError((ValidationError)result);
            return false;
        }
        if (result instanceof String) {
            ((ValidationErrorAware)((Object)widget)).setValidationError(new ValidationError((String)result, false));
            return false;
        }
        if (result instanceof XMLizable) {
            ((ValidationErrorAware)((Object)widget)).setValidationError(new ValidationError((XMLizable)result));
            return false;
        }
        throw new RuntimeException("Validation script returned an unexpected value of type " + result.getClass());
    }
}

