/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Map;
import org.apache.cocoon.components.flow.FlowHelper;
import org.apache.cocoon.components.flow.javascript.JavaScriptFlowHelper;
import org.apache.cocoon.components.flow.javascript.fom.FOM_JavaScriptFlowHelper;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.forms.util.FOM_SimpleCocoon;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.Element;

public class JavaScriptHelper {
    private static Scriptable _rootScope;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Script buildScript(Element element) throws IOException {
        Script script;
        String jsText = DomHelper.getElementText(element);
        String sourceName = DomHelper.getSystemIdLocation(element);
        Context ctx = Context.enter();
        try {
            script = ctx.compileReader((Reader)new StringReader(jsText), sourceName == null ? "<unknown>" : sourceName, DomHelper.getLineLocation(element), null);
        }
        finally {
            Context.exit();
        }
        return script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Function buildFunction(Element element, String name, String[] argumentNames) throws IOException {
        Function func;
        StringBuffer buffer = new StringBuffer("function ").append(name).append("(");
        for (int i = 0; i < argumentNames.length; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(argumentNames[i]);
        }
        buffer.append(") {\n").append(DomHelper.getElementText(element)).append("\n}");
        String jsText = buffer.toString();
        String sourceName = DomHelper.getSystemIdLocation(element);
        Context ctx = Context.enter();
        try {
            func = ctx.compileFunction(JavaScriptHelper.getRootScope(null), jsText, sourceName == null ? "<unknown>" : sourceName, DomHelper.getLineLocation(element) - 1, null);
        }
        finally {
            Context.exit();
        }
        return func;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Scriptable getRootScope(Map objectModel) {
        Context ctx;
        if (_rootScope == null) {
            ctx = Context.enter();
            try {
                _rootScope = ctx.initStandardObjects(null);
                try {
                    ScriptableObject.defineClass((Scriptable)_rootScope, (Class)FOM_SimpleCocoon.class);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot setup a root context with a cocoon object for javascript", e);
                }
            }
            finally {
                Context.exit();
            }
        }
        if (objectModel == null) {
            return _rootScope;
        }
        ctx = Context.enter();
        try {
            Scriptable scope = ctx.newObject(_rootScope);
            FOM_SimpleCocoon cocoon = (FOM_SimpleCocoon)ctx.newObject(scope, "FOM_SimpleCocoon", new Object[0]);
            cocoon.setObjectModel(objectModel);
            cocoon.setParentScope(scope);
            scope.put("cocoon", scope, (Object)cocoon);
            Scriptable scriptable = scope;
            return scriptable;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot setup a root context with a cocoon object for javascript", e);
        }
        finally {
            Context.exit();
        }
    }

    public static Scriptable getParentScope(Map objectModel) {
        Scriptable parentScope = null;
        if (objectModel != null) {
            parentScope = FOM_JavaScriptFlowHelper.getFOM_FlowScope((Map)objectModel);
        }
        if (parentScope != null) {
            return parentScope;
        }
        return JavaScriptHelper.getRootScope(objectModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object execScript(Script script, Map values, Map objectModel) throws JavaScriptException {
        Context ctx = Context.enter();
        try {
            Object viewData;
            Scriptable scope;
            Scriptable parentScope = JavaScriptHelper.getParentScope(objectModel);
            try {
                scope = ctx.newObject(parentScope);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot create script scope", e);
            }
            scope.setParentScope(parentScope);
            Iterator iter = values.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                scope.put(key, scope, (Object)Context.toObject(value, (Scriptable)scope));
            }
            if (objectModel != null && (viewData = FlowHelper.getContextObject((Map)objectModel)) != null) {
                scope.put("viewData", scope, (Object)Context.toObject((Object)viewData, (Scriptable)scope));
            }
            Object result = script.exec(ctx, scope);
            Object object = JavaScriptFlowHelper.unwrap((Object)result);
            return object;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object callFunction(Function func, Object thisObject, Object[] arguments, Map objectModel) throws JavaScriptException {
        Context ctx = Context.enter();
        try {
            Scriptable scope = JavaScriptHelper.getParentScope(objectModel);
            if (objectModel != null) {
                Scriptable newScope;
                Object viewData = FlowHelper.getContextObject((Map)objectModel);
                try {
                    newScope = ctx.newObject(scope);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot create function scope", e);
                }
                newScope.setParentScope(scope);
                scope = newScope;
                if (viewData != null) {
                    scope.put("viewData", scope, (Object)Context.toObject((Object)viewData, (Scriptable)scope));
                } else {
                    scope.put("viewData", scope, null);
                }
            }
            func.setParentScope(scope);
            Object result = func.call(ctx, scope, thisObject == null ? null : Context.toObject((Object)thisObject, (Scriptable)scope), arguments);
            Object object = JavaScriptFlowHelper.unwrap((Object)result);
            return object;
        }
        finally {
            Context.exit();
        }
    }
}

