/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cocoon.forms.formmodel.tree.SourceTreeModelDefinition;
import org.apache.cocoon.forms.formmodel.tree.TreeModel;
import org.apache.cocoon.forms.formmodel.tree.TreeModelHelper;
import org.apache.cocoon.forms.formmodel.tree.TreeModelListener;
import org.apache.cocoon.forms.formmodel.tree.TreePath;
import org.apache.cocoon.util.WildcardMatcherHelper;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.TraversableSource;

public class SourceTreeModel
implements TreeModel {
    private TreeModelHelper helper = new TreeModelHelper(this);
    private List fileIncludePatterns;
    private List fileExcludePatterns;
    private List dirIncludePatterns;
    private List dirExcludePatterns;
    private boolean hasPatterns = false;
    private TraversableSource rootSource;
    private String rootURL;
    private SourceResolver resolver;

    public SourceTreeModel(SourceResolver resolver, String rootURL) {
        this.resolver = resolver;
        this.rootURL = rootURL;
    }

    public SourceTreeModel(SourceTreeModelDefinition definition) {
        this.rootURL = definition.getRootURL();
        this.resolver = definition.getResolver();
        this.fileIncludePatterns = definition.getFileIncludePatterns();
        this.fileExcludePatterns = definition.getFileExcludePatterns();
        this.dirIncludePatterns = definition.getDirectoryIncludePatterns();
        this.dirExcludePatterns = definition.getDirectoryExcludePatterns();
        this.hasPatterns = this.fileIncludePatterns != null || this.fileExcludePatterns != null || this.dirIncludePatterns != null || this.dirExcludePatterns != null;
    }

    public Object getRoot() {
        if (this.rootSource == null) {
            try {
                this.rootSource = (TraversableSource)this.resolver.resolveURI(this.rootURL);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot resolve " + this.rootURL, e);
            }
        }
        return this.rootSource;
    }

    public Collection getChildren(Object parent) {
        if (parent instanceof TraversableSource) {
            TraversableSource dir = (TraversableSource)parent;
            try {
                return dir.isCollection() ? this.filterChildren(dir.getChildren()) : null;
            }
            catch (SourceException e) {
                throw new RuntimeException("getChildren", e);
            }
        }
        return null;
    }

    private Collection filterChildren(Collection coll) {
        if (!this.hasPatterns) {
            return coll;
        }
        ArrayList<TraversableSource> result = new ArrayList<TraversableSource>();
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            TraversableSource src = (TraversableSource)iter.next();
            boolean matches = true;
            matches = src.isCollection() ? this.matches(src, this.dirIncludePatterns, this.dirExcludePatterns) : this.matches(src, this.fileIncludePatterns, this.fileExcludePatterns);
            if (!matches) continue;
            result.add(src);
        }
        return result;
    }

    private boolean matches(TraversableSource src, List includes, List excludes) {
        int i;
        boolean matches = true;
        String name = src.getName();
        if (includes != null && includes.size() > 0) {
            matches = false;
            for (i = 0; i < includes.size(); ++i) {
                if (WildcardMatcherHelper.match((String)((String)includes.get(i)), (String)name) == null) continue;
                matches = true;
                break;
            }
        }
        if (matches && excludes != null && excludes.size() > 0) {
            for (i = 0; i < excludes.size(); ++i) {
                if (WildcardMatcherHelper.match((String)((String)excludes.get(i)), (String)name) == null) continue;
                matches = false;
                break;
            }
        }
        return matches;
    }

    public boolean isLeaf(Object obj) {
        return !(obj instanceof TraversableSource) || !((TraversableSource)obj).isCollection();
    }

    public String getChildKey(Object parent, Object child) {
        return ((TraversableSource)child).getName();
    }

    public Object getChild(Object parent, String key) {
        try {
            return ((TraversableSource)parent).getChild(key);
        }
        catch (SourceException e) {
            throw new RuntimeException("getChild", e);
        }
    }

    public void setRootURL(String url) {
        if (this.rootSource != null) {
            this.resolver.release((Source)this.rootSource);
            this.rootSource = null;
        }
        this.rootURL = url;
        this.helper.fireTreeStructureChanged(TreePath.ROOT_PATH);
    }

    public void setRootSource(TraversableSource src) {
        this.rootSource = src;
        this.helper.fireTreeStructureChanged(TreePath.ROOT_PATH);
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.helper.addTreeModelListener(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.helper.removeTreeModelListener(l);
    }

    public Object getNode(TreePath path) {
        return this.helper.getNode(path);
    }
}

