/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel.algorithms;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.formmodel.CannotYetResolveWarning;
import org.apache.cocoon.forms.formmodel.ExpressionContextImpl;
import org.apache.cocoon.forms.formmodel.Form;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.algorithms.SimpleFormula;
import org.apache.cocoon.forms.util.WidgetFinder;
import org.outerj.expression.Expression;
import org.outerj.expression.ExpressionContext;
import org.outerj.expression.ExpressionException;

public class RepeatedFormula
extends SimpleFormula {
    private Expression initialResult = null;
    private String repeatOn = null;

    public Object calculate(Form form, Widget parent, Datatype datatype) {
        try {
            Object result = null;
            if (this.initialResult != null) {
                result = this.initialResult.evaluate((ExpressionContext)new ExpressionContextImpl(parent, true));
            }
            WidgetFinder finder = new WidgetFinder(parent, this.repeatOn, false);
            Collection widgets = finder.getWidgets();
            Iterator iter = widgets.iterator();
            while (iter.hasNext()) {
                Widget widget = (Widget)iter.next();
                ResultExpressionContext ctx = new ResultExpressionContext(widget, result);
                result = this.formula.evaluate((ExpressionContext)ctx);
            }
            return result;
        }
        catch (CannotYetResolveWarning w) {
            return null;
        }
        catch (ExpressionException e) {
            throw new Error("Error evaluating calculated field formula", e);
        }
    }

    public Expression getInitialResult() {
        return this.initialResult;
    }

    public void setInitialResult(Expression initialResult) {
        this.initialResult = initialResult;
    }

    public String getRepeatOn() {
        return this.repeatOn;
    }

    public void setRepeatOn(String iterateOn) {
        this.repeatOn = iterateOn;
    }

    static class ResultExpressionContext
    extends ExpressionContextImpl {
        Object result = null;
        Widget current = null;

        public ResultExpressionContext(Widget widget, Object result) {
            super(widget.getParent(), true);
            this.current = widget;
            this.result = result;
        }

        public Object resolveVariable(String name) {
            if (name.equals("formulaResult")) {
                return this.result;
            }
            if (name.equals("formulaCurrent")) {
                Object value = this.current.getValue();
                if (value == null && this.current.isRequired()) {
                    throw new CannotYetResolveWarning();
                }
                if (value instanceof Long) {
                    return new BigDecimal((double)((Long)value).longValue());
                }
                if (value instanceof Integer) {
                    return new BigDecimal((double)((Integer)value).intValue());
                }
                return value;
            }
            return super.resolveVariable(name);
        }
    }
}

