/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.forms.FormsRuntimeException;
import org.apache.cocoon.forms.formmodel.ClassDefinition;
import org.apache.cocoon.forms.formmodel.ContainerDefinition;
import org.apache.cocoon.forms.formmodel.ContainerWidget;
import org.apache.cocoon.forms.formmodel.DuplicateIdException;
import org.apache.cocoon.forms.formmodel.FormDefinition;
import org.apache.cocoon.forms.formmodel.IncompletenessException;
import org.apache.cocoon.forms.formmodel.NewDefinition;
import org.apache.cocoon.forms.formmodel.RepeaterDefinition;
import org.apache.cocoon.forms.formmodel.UnionDefinition;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.util.location.Location;

public class WidgetDefinitionList {
    private List widgetDefinitions = new ArrayList();
    private Map widgetDefinitionsById = new HashMap();
    private WidgetDefinition containerDefinition;
    private boolean wasHere;
    private ListIterator definitionsIt = this.widgetDefinitions.listIterator();

    public WidgetDefinitionList(WidgetDefinition definition) {
        this.containerDefinition = definition;
        this.wasHere = false;
    }

    public int size() {
        return this.widgetDefinitions.size();
    }

    public void addWidgetDefinition(WidgetDefinition widgetDefinition) throws DuplicateIdException {
        String id = widgetDefinition.getId();
        if (!(widgetDefinition instanceof NewDefinition)) {
            if (this.widgetDefinitionsById.containsKey(id)) {
                Location containerLocation = this.containerDefinition.getLocation();
                Location firstLocation = this.getWidgetDefinition(id).getLocation();
                throw new DuplicateIdException("Detected duplicate widget id '" + id + "'.\n" + "Container widget '" + this.containerDefinition.getId() + "' at " + containerLocation + "\n" + "already contains a widget with the same id at " + firstLocation + ".", widgetDefinition);
            }
            this.widgetDefinitionsById.put(widgetDefinition.getId(), widgetDefinition);
        }
        this.definitionsIt.add(widgetDefinition);
    }

    public List getWidgetDefinitions() {
        return this.widgetDefinitions;
    }

    public boolean hasWidget(String id) {
        return this.widgetDefinitionsById.containsKey(id);
    }

    public WidgetDefinition getWidgetDefinition(String id) {
        return (WidgetDefinition)this.widgetDefinitionsById.get(id);
    }

    public void resolve(List parents, WidgetDefinition parent) throws Exception {
        if (!this.wasHere) {
            this.wasHere = true;
            this.definitionsIt = this.widgetDefinitions.listIterator();
            parents.add(this.containerDefinition);
            while (this.definitionsIt.hasNext()) {
                WidgetDefinition widgetDefinition = (WidgetDefinition)this.definitionsIt.next();
                if (widgetDefinition instanceof ClassDefinition) continue;
                if (widgetDefinition instanceof NewDefinition) {
                    this.definitionsIt.remove();
                    ((NewDefinition)widgetDefinition).resolve(parents, this.containerDefinition);
                    continue;
                }
                if (!(widgetDefinition instanceof ContainerDefinition)) continue;
                ((ContainerDefinition)widgetDefinition).resolve(parents, this.containerDefinition);
            }
            parents.remove(parents.size() - 1);
            this.wasHere = false;
        } else {
            WidgetDefinition widgetDefinition;
            ListIterator parentsIt = parents.listIterator(parents.size());
            while (parentsIt.hasPrevious() && !((widgetDefinition = (WidgetDefinition)parentsIt.previous()) instanceof UnionDefinition) && !(widgetDefinition instanceof RepeaterDefinition)) {
                if (widgetDefinition != this.containerDefinition) continue;
                Location location = this.containerDefinition.getLocation();
                if (parent instanceof FormDefinition) {
                    throw new FormsException("Container: Non-terminating recursion detected in form definition.", location);
                }
                throw new FormsException("Container: Non-terminating recursion detected in widget definition: " + parent.getId(), location);
            }
        }
    }

    public void createWidget(Widget parent, String id) {
        WidgetDefinition widgetDefinition = (WidgetDefinition)this.widgetDefinitionsById.get(id);
        if (widgetDefinition == null) {
            throw new FormsRuntimeException(this.containerDefinition.getId() + ": WidgetDefinition '" + id + "' does not exist.", this.containerDefinition.getLocation());
        }
        Widget widget = widgetDefinition.createInstance();
        if (widget != null) {
            ((ContainerWidget)parent).addChild(widget);
        }
    }

    public void createWidgets(Widget parent) {
        Iterator i = this.widgetDefinitions.iterator();
        while (i.hasNext()) {
            WidgetDefinition widgetDefinition = (WidgetDefinition)i.next();
            Widget widget = widgetDefinition.createInstance();
            if (widget == null) continue;
            ((ContainerWidget)parent).addChild(widget);
        }
    }

    public void checkCompleteness() throws IncompletenessException {
        if (!this.wasHere) {
            this.wasHere = true;
            Iterator i = this.widgetDefinitions.iterator();
            while (i.hasNext()) {
                ((WidgetDefinition)i.next()).checkCompleteness();
            }
            this.wasHere = false;
        }
    }
}

