/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.event.ValueChangedEvent;
import org.apache.cocoon.forms.event.ValueChangedListener;
import org.apache.cocoon.forms.event.ValueChangedListenerEnabled;
import org.apache.cocoon.forms.event.WidgetEvent;
import org.apache.cocoon.forms.event.WidgetEventMulticaster;
import org.apache.cocoon.forms.formmodel.AbstractWidget;
import org.apache.cocoon.forms.formmodel.Form;
import org.apache.cocoon.forms.formmodel.UploadDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.util.I18nMessage;
import org.apache.cocoon.forms.validation.ValidationError;
import org.apache.cocoon.forms.validation.ValidationErrorAware;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.cocoon.servlet.multipart.RejectedPart;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.ObjectUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Upload
extends AbstractWidget
implements ValidationErrorAware,
ValueChangedListenerEnabled {
    private static final String UPLOAD_EL = "upload";
    private static final String VALUE_EL = "value";
    private static final String VALIDATION_MSG_EL = "validation-message";
    private final UploadDefinition definition;
    private Part part;
    private ValidationError validationError;
    private ValueChangedListener listener;

    public Upload(UploadDefinition uploadDefinition) {
        super(uploadDefinition);
        this.definition = uploadDefinition;
        this.listener = uploadDefinition.getValueChangedListener();
    }

    public WidgetDefinition getDefinition() {
        return this.definition;
    }

    public UploadDefinition getUploadDefinition() {
        return this.definition;
    }

    public Object getValue() {
        return this.isValid() ? this.part : null;
    }

    public void setValue(Object object) {
        if (object == this.part) {
            return;
        }
        if (object != null && !(object instanceof Part)) {
            throw new RuntimeException("The value of an upload widget must be of type " + Part.class + ".");
        }
        this.part = (Part)object;
        this.changed();
    }

    public void readFromRequest(FormContext formContext) {
        if (!this.getCombinedState().isAcceptingInputs()) {
            return;
        }
        Form form = this.getForm();
        Request request = formContext.getRequest();
        String fullId = this.getRequestParameterName();
        Object obj = request.get(fullId);
        if (fullId.equals(request.getParameter("forms_submit_id"))) {
            form.setSubmitWidget(this);
        }
        if (obj instanceof Part) {
            Part requestPart = (Part)obj;
            if (this.part != null) {
                this.part.dispose();
            }
            requestPart.setDisposeWithRequest(false);
            this.part = requestPart;
            if (this.validateOversize()) {
                this.setValidationError(null);
            }
            this.changed();
        } else if (obj != null || form.getSubmitWidget() == this) {
            if (this.part != null) {
                this.part.dispose();
                this.part = null;
            }
            this.setValidationError(null);
            this.changed();
        }
    }

    private void changed() {
        if (this.hasValueChangedListeners() || this.getForm().hasFormHandler()) {
            this.getForm().addWidgetEvent(new ValueChangedEvent(this, null, this.part));
        }
        this.getForm().addWidgetUpdate(this);
    }

    private boolean validateMimeType() {
        String mimeTypes = this.definition.getMimeTypes();
        if (mimeTypes != null) {
            StringTokenizer tok = new StringTokenizer(mimeTypes, ", ");
            String contentType = this.part.getMimeType();
            while (tok.hasMoreTokens()) {
                if (!tok.nextToken().equals(contentType)) continue;
                return true;
            }
            I18nMessage message = new I18nMessage("upload.invalid-type", new String[]{contentType}, "forms");
            this.setValidationError(new ValidationError(message));
            return false;
        }
        return true;
    }

    private boolean validateOversize() {
        if (!this.part.isRejected()) {
            return true;
        }
        RejectedPart rjp = (RejectedPart)this.part;
        int size = (rjp.getContentLength() + 512) / 1024;
        int maxSize = (rjp.getMaxContentLength() + 512) / 1024;
        String[] i18nParams = new String[]{String.valueOf(size), String.valueOf(maxSize)};
        I18nMessage i18nMessage = new I18nMessage("upload.rejected", i18nParams, "forms");
        this.setValidationError(new ValidationError(i18nMessage));
        return false;
    }

    public boolean validate() {
        if (!this.getCombinedState().isValidatingValues()) {
            this.wasValid = true;
            return true;
        }
        if (this.part == null) {
            if (this.definition.isRequired()) {
                I18nMessage i18nMessage = new I18nMessage("general.field-required", "forms");
                this.setValidationError(new ValidationError(i18nMessage));
            }
        } else if (this.validateOversize() && this.validateMimeType()) {
            super.validate();
        }
        this.wasValid = this.validationError == null;
        return this.wasValid;
    }

    public ValidationError getValidationError() {
        return this.validationError;
    }

    public void setValidationError(ValidationError error) {
        if (!ObjectUtils.equals((Object)this.validationError, (Object)error)) {
            this.validationError = error;
            this.getForm().addWidgetUpdate(this);
        }
    }

    public void addValueChangedListener(ValueChangedListener listener) {
        this.listener = WidgetEventMulticaster.add(this.listener, listener);
    }

    public void removeValueChangedListener(ValueChangedListener listener) {
        this.listener = WidgetEventMulticaster.remove(this.listener, listener);
    }

    public boolean hasValueChangedListeners() {
        return this.listener != null;
    }

    public void broadcastEvent(WidgetEvent event) {
        if (event instanceof ValueChangedEvent) {
            if (this.listener != null) {
                this.listener.valueChanged((ValueChangedEvent)event);
            }
        } else {
            super.broadcastEvent(event);
        }
    }

    public String getXMLElementName() {
        return UPLOAD_EL;
    }

    public AttributesImpl getXMLElementAttributes() {
        AttributesImpl attrs = super.getXMLElementAttributes();
        attrs.addCDATAAttribute("id", this.getRequestParameterName());
        attrs.addCDATAAttribute("required", String.valueOf(this.definition.isRequired()));
        if (this.definition.getMimeTypes() != null) {
            attrs.addCDATAAttribute("mime-types", this.definition.getMimeTypes());
        }
        return attrs;
    }

    public void generateItemSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        if (this.part != null) {
            String name = (String)this.part.getHeaders().get("filename");
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value", XMLUtils.EMPTY_ATTRIBUTES);
            contentHandler.characters(name.toCharArray(), 0, name.length());
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value");
        }
        if (this.validationError != null) {
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", VALIDATION_MSG_EL, "fi:validation-message", XMLUtils.EMPTY_ATTRIBUTES);
            this.validationError.generateSaxFragment(contentHandler);
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", VALIDATION_MSG_EL, "fi:validation-message");
        }
    }
}

