/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.Iterator;
import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.forms.event.ActionListener;
import org.apache.cocoon.forms.formmodel.AbstractWidgetDefinitionBuilder;
import org.apache.cocoon.forms.formmodel.RowActionDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinitionBuilderContext;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.util.Deprecation;
import org.w3c.dom.Element;

public class RowActionDefinitionBuilder
extends AbstractWidgetDefinitionBuilder {
    public WidgetDefinition buildWidgetDefinition(Element widgetElement, WidgetDefinitionBuilderContext context) throws Exception {
        String actionCommand = DomHelper.getAttribute(widgetElement, "command", null);
        if (actionCommand == null && (actionCommand = DomHelper.getAttribute(widgetElement, "action-command", null)) != null) {
            Deprecation.logger.info((Object)("The 'action-command' attribute is deprecated and replaced by 'command', at " + DomHelper.getLocation(widgetElement)));
        }
        if (actionCommand == null) {
            throw new FormsException("Required attribute 'command' is missing.", DomHelper.getLocationObject(widgetElement));
        }
        RowActionDefinition definition = this.createDefinition(widgetElement, actionCommand);
        this.setupDefinition(widgetElement, definition, context);
        this.setDisplayData(widgetElement, definition);
        definition.setActionCommand(actionCommand);
        Element buggyOnActivate = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", "on-activate", false);
        if (buggyOnActivate != null) {
            throw new FormsException("Use 'on-action' instead of 'on-activate' on row-action.", DomHelper.getLocationObject(buggyOnActivate));
        }
        Iterator i = this.buildEventListeners(widgetElement, "on-action", ActionListener.class).iterator();
        while (i.hasNext()) {
            definition.addActionListener((ActionListener)i.next());
        }
        definition.makeImmutable();
        return definition;
    }

    protected RowActionDefinition createDefinition(Element element, String actionCommand) throws Exception {
        if ("delete".equals(actionCommand)) {
            return new RowActionDefinition.DeleteRowDefinition();
        }
        if ("add-after".equals(actionCommand)) {
            return new RowActionDefinition.AddAfterDefinition();
        }
        if ("move-up".equals(actionCommand)) {
            return new RowActionDefinition.MoveUpDefinition();
        }
        if ("move-down".equals(actionCommand)) {
            return new RowActionDefinition.MoveDownDefinition();
        }
        throw new FormsException("Unknown repeater row action '" + actionCommand + "'.", DomHelper.getLocationObject(element));
    }
}

