/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.lang.reflect.Array;
import java.util.Locale;
import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.SelectionList;
import org.apache.cocoon.forms.datatype.convertor.ConversionResult;
import org.apache.cocoon.forms.datatype.convertor.Convertor;
import org.apache.cocoon.forms.event.ValueChangedEvent;
import org.apache.cocoon.forms.event.ValueChangedListener;
import org.apache.cocoon.forms.event.ValueChangedListenerEnabled;
import org.apache.cocoon.forms.event.WidgetEvent;
import org.apache.cocoon.forms.event.WidgetEventMulticaster;
import org.apache.cocoon.forms.formmodel.AbstractWidget;
import org.apache.cocoon.forms.formmodel.DataWidget;
import org.apache.cocoon.forms.formmodel.ExpressionContextImpl;
import org.apache.cocoon.forms.formmodel.MultiValueFieldDefinition;
import org.apache.cocoon.forms.formmodel.SelectableWidget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.util.I18nMessage;
import org.apache.cocoon.forms.validation.ValidationError;
import org.apache.cocoon.forms.validation.ValidationErrorAware;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MultiValueField
extends AbstractWidget
implements ValidationErrorAware,
SelectableWidget,
DataWidget,
ValueChangedListenerEnabled {
    private static final String MULTIVALUEFIELD_EL = "multivaluefield";
    private static final String VALUES_EL = "values";
    private static final String VALUE_EL = "value";
    private static final String VALIDATION_MSG_EL = "validation-message";
    private final MultiValueFieldDefinition definition;
    private SelectionList selectionList;
    private String[] enteredValues;
    private String invalidEnteredValue;
    private Object[] values;
    private ValidationError validationError;
    private ValueChangedListener listener;

    public MultiValueField(MultiValueFieldDefinition definition) {
        super(definition);
        this.definition = definition;
        this.listener = definition.getValueChangedListener();
    }

    public void initialize() {
        this.selectionList = this.definition.getSelectionList();
        super.initialize();
    }

    public WidgetDefinition getDefinition() {
        return this.definition;
    }

    public void readFromRequest(FormContext formContext) {
        if (!this.getCombinedState().isAcceptingInputs()) {
            return;
        }
        this.enteredValues = formContext.getRequest().getParameterValues(this.getRequestParameterName());
        this.invalidEnteredValue = null;
        this.validationError = null;
        Object[] oldValues = this.values;
        this.values = null;
        boolean conversionFailed = false;
        if (this.enteredValues != null) {
            Object[] tempValues = (Object[])Array.newInstance(this.getDatatype().getTypeClass(), this.enteredValues.length);
            for (int i = 0; i < this.enteredValues.length; ++i) {
                String param = this.enteredValues[i];
                ConversionResult conversionResult = this.definition.getDatatype().convertFromString(param, formContext.getLocale());
                if (!conversionResult.isSuccessful()) {
                    conversionFailed = true;
                    this.invalidEnteredValue = param;
                    break;
                }
                tempValues[i] = conversionResult.getResult();
            }
            this.values = !conversionFailed ? tempValues : null;
        } else {
            this.values = new Object[0];
        }
        this.engenderChangeEvent(oldValues);
    }

    private void engenderChangeEvent(Object[] oldValues) {
        boolean hasListeners;
        boolean bl = hasListeners = this.hasValueChangedListeners() || this.getForm().hasFormHandler();
        if (hasListeners && this.values != null) {
            boolean changed = false;
            if (oldValues == null) {
                changed = true;
            } else if (oldValues.length != this.values.length) {
                changed = true;
            } else {
                for (int i = 0; i < this.values.length; ++i) {
                    if (this.values[i].equals(oldValues[i])) continue;
                    changed = true;
                    break;
                }
            }
            if (changed) {
                this.getForm().addWidgetEvent(new ValueChangedEvent(this, oldValues, this.values));
            }
        }
    }

    public boolean validate() {
        if (!this.getCombinedState().isValidatingValues()) {
            this.wasValid = true;
            return true;
        }
        if (this.values != null) {
            this.validationError = this.definition.getDatatype().validate(this.values, new ExpressionContextImpl(this));
        } else if (this.invalidEnteredValue != null) {
            this.validationError = new ValidationError(new I18nMessage("multivaluefield.conversionfailed", new String[]{this.invalidEnteredValue}, "forms"));
        }
        this.wasValid = this.validationError == null ? super.validate() : false;
        return this.wasValid;
    }

    public String getXMLElementName() {
        return MULTIVALUEFIELD_EL;
    }

    public void generateItemSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", VALUES_EL, "fi:values", XMLUtils.EMPTY_ATTRIBUTES);
        Convertor convertor = this.definition.getDatatype().getConvertor();
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value", XMLUtils.EMPTY_ATTRIBUTES);
                String value = convertor.convertToString(this.values[i], locale, null);
                contentHandler.characters(value.toCharArray(), 0, value.length());
                contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value");
            }
        } else if (this.enteredValues != null) {
            for (int i = 0; i < this.enteredValues.length; ++i) {
                contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value", XMLUtils.EMPTY_ATTRIBUTES);
                String value = this.enteredValues[i];
                contentHandler.characters(value.toCharArray(), 0, value.length());
                contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value");
            }
        }
        contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", VALUES_EL, "fi:values");
        if (this.validationError != null) {
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", VALIDATION_MSG_EL, "fi:validation-message", XMLUtils.EMPTY_ATTRIBUTES);
            this.validationError.generateSaxFragment(contentHandler);
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", VALIDATION_MSG_EL, "fi:validation-message");
        }
        if (this.selectionList != null) {
            this.selectionList.generateSaxFragment(contentHandler, locale);
        }
        this.definition.getDatatype().generateSaxFragment(contentHandler, locale);
    }

    public Object getValue() {
        return this.values;
    }

    public void setValue(Object value) {
        if (value == null) {
            this.setValues(new Object[0]);
        } else if (value.getClass().isArray()) {
            this.setValues((Object[])value);
        } else {
            throw new RuntimeException("Cannot set value of field '" + this.getRequestParameterName() + "' with an object of type " + value.getClass().getName());
        }
        this.getForm().addWidgetUpdate(this);
    }

    public void setValues(Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (this.definition.getDatatype().getTypeClass().isAssignableFrom(values[i].getClass())) continue;
            throw new RuntimeException("Cannot set value of field '" + this.getRequestParameterName() + "' with an object of type " + values[i].getClass().getName());
        }
        Object[] oldValues = this.values;
        this.values = values;
        this.engenderChangeEvent(oldValues);
        this.getForm().addWidgetUpdate(this);
    }

    public void setSelectionList(SelectionList selectionList) {
        if (selectionList == null) {
            throw new IllegalArgumentException("An MultiValueField's selection list cannot be null.");
        }
        if (selectionList.getDatatype() != null && selectionList.getDatatype() != this.definition.getDatatype()) {
            throw new RuntimeException("Tried to assign a SelectionList that is not associated with this widget's datatype.");
        }
        this.selectionList = selectionList;
        this.getForm().addWidgetUpdate(this);
    }

    public void setSelectionList(String uri) {
        this.setSelectionList(this.definition.buildSelectionList(uri));
    }

    public void setSelectionList(Object model, String valuePath, String labelPath) {
        this.setSelectionList(this.definition.buildSelectionListFromModel(model, valuePath, labelPath));
    }

    public void broadcastEvent(WidgetEvent event) {
        if (event instanceof ValueChangedEvent) {
            if (this.listener != null) {
                this.listener.valueChanged((ValueChangedEvent)event);
            }
        } else {
            super.broadcastEvent(event);
        }
    }

    public ValidationError getValidationError() {
        return this.validationError;
    }

    public void setValidationError(ValidationError error) {
        this.validationError = error;
        this.getForm().addWidgetUpdate(this);
    }

    public Datatype getDatatype() {
        return this.definition.getDatatype();
    }

    public void addValueChangedListener(ValueChangedListener listener) {
        this.listener = WidgetEventMulticaster.add(this.listener, listener);
    }

    public void removeValueChangedListener(ValueChangedListener listener) {
        this.listener = WidgetEventMulticaster.remove(this.listener, listener);
    }

    public boolean hasValueChangedListeners() {
        return this.listener != null;
    }
}

