/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.forms.FormsRuntimeException;
import org.apache.cocoon.forms.formmodel.AggregateField;
import org.apache.cocoon.forms.formmodel.DuplicateIdException;
import org.apache.cocoon.forms.formmodel.Field;
import org.apache.cocoon.forms.formmodel.FieldDefinition;
import org.apache.cocoon.forms.formmodel.IncompletenessException;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinitionList;
import org.apache.excalibur.xml.sax.XMLizable;
import org.apache.oro.text.regex.Pattern;
import org.outerj.expression.Expression;

public class AggregateFieldDefinition
extends FieldDefinition {
    private Expression combineExpr;
    private String splitRegexp;
    private Pattern splitPattern;
    protected XMLizable splitFailMessage;
    private List splitMappings = new ArrayList();
    private Set mappedFields = new HashSet();
    private WidgetDefinitionList container = new WidgetDefinitionList(this);

    public void initializeFrom(WidgetDefinition definition) throws Exception {
        super.initializeFrom(definition);
        if (!(definition instanceof AggregateFieldDefinition)) {
            throw new FormsException("Ancestor definition " + definition.getClass().getName() + " is not an AggregateFieldDefinition.", this.getLocation());
        }
        AggregateFieldDefinition other = (AggregateFieldDefinition)definition;
        this.combineExpr = other.combineExpr;
        this.splitRegexp = other.splitRegexp;
        this.splitPattern = other.splitPattern;
        this.splitFailMessage = other.splitFailMessage;
        Iterator defs = other.container.getWidgetDefinitions().iterator();
        while (defs.hasNext()) {
            this.container.addWidgetDefinition((WidgetDefinition)defs.next());
        }
        Collections.copy(this.splitMappings, other.splitMappings);
        Iterator fields = other.mappedFields.iterator();
        while (fields.hasNext()) {
            this.mappedFields.add(fields.next());
        }
    }

    public void addWidgetDefinition(WidgetDefinition widgetDefinition) throws DuplicateIdException {
        this.checkMutable();
        this.container.addWidgetDefinition(widgetDefinition);
    }

    public void checkCompleteness() throws IncompletenessException {
        super.checkCompleteness();
        if (this.container.size() == 0) {
            throw new IncompletenessException("Aggregate field '" + this.getId() + "' doesn't have any child widgets.", this);
        }
        if (this.combineExpr == null) {
            throw new IncompletenessException("Aggregate field '" + this.getId() + "' requires combine expression.", this);
        }
        if (this.splitPattern == null) {
            throw new IncompletenessException("Aggregate field '" + this.getId() + "' requires split regular expression.", this);
        }
        if (this.splitMappings.size() == 0) {
            throw new IncompletenessException("Aggregate field '" + this.getId() + "' requires at least one group to field mapping.", this);
        }
        Iterator i = this.container.getWidgetDefinitions().iterator();
        while (i.hasNext()) {
            ((WidgetDefinition)i.next()).checkCompleteness();
        }
    }

    public boolean hasWidget(String id) {
        return this.container.hasWidget(id);
    }

    protected void setCombineExpression(Expression expression) {
        this.checkMutable();
        this.combineExpr = expression;
    }

    public Expression getCombineExpression() {
        return this.combineExpr;
    }

    protected void setSplitPattern(Pattern pattern, String regexp) {
        this.checkMutable();
        this.splitPattern = pattern;
        this.splitRegexp = regexp;
    }

    public Pattern getSplitPattern() {
        return this.splitPattern;
    }

    public String getSplitRegexp() {
        return this.splitRegexp;
    }

    public XMLizable getSplitFailMessage() {
        return this.splitFailMessage;
    }

    protected void setSplitFailMessage(XMLizable splitFailMessage) {
        this.checkMutable();
        this.splitFailMessage = splitFailMessage;
    }

    protected void addSplitMapping(int group, String fieldId) {
        this.checkMutable();
        if (this.mappedFields.contains(fieldId)) {
            throw new FormsRuntimeException("Field '" + fieldId + "' is already mapped to another group.", this.getLocation());
        }
        this.mappedFields.add(fieldId);
        this.splitMappings.add(new SplitMapping(group, fieldId));
    }

    public Iterator getSplitMappingsIterator() {
        return this.splitMappings.iterator();
    }

    public Widget createInstance() {
        AggregateField aggregateField = new AggregateField(this);
        Iterator i = this.container.getWidgetDefinitions().iterator();
        while (i.hasNext()) {
            FieldDefinition fieldDefinition = (FieldDefinition)i.next();
            aggregateField.addField((Field)fieldDefinition.createInstance());
        }
        return aggregateField;
    }

    public static class SplitMapping {
        private int group;
        private String fieldId;

        public SplitMapping(int group, String fieldId) {
            this.group = group;
            this.fieldId = fieldId;
        }

        public int getGroup() {
            return this.group;
        }

        public String getFieldId() {
            return this.fieldId;
        }
    }
}

