/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype;

import java.util.Map;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.DatatypeBuilder;
import org.apache.cocoon.forms.datatype.DatatypeManager;
import org.apache.cocoon.forms.datatype.ValidationRule;
import org.apache.cocoon.forms.datatype.ValidationRuleBuilder;
import org.apache.cocoon.forms.datatype.convertor.Convertor;
import org.apache.cocoon.forms.util.DomHelper;
import org.w3c.dom.Element;

public class DefaultDatatypeManager
implements DatatypeManager {
    private Map datatypeBuilders;
    private Map validatorRuleBuilders;

    public Datatype createDatatype(Element datatypeElement, boolean arrayType) throws Exception {
        String typeName = DomHelper.getAttribute(datatypeElement, "base");
        DatatypeBuilder builder = (DatatypeBuilder)this.datatypeBuilders.get(typeName);
        if (builder == null) {
            throw new Exception("Unknown datatype '" + typeName + "' specified at " + DomHelper.getLocation(datatypeElement));
        }
        return builder.build(datatypeElement, arrayType, this);
    }

    public ValidationRule createValidationRule(Element validationRuleElement) throws Exception {
        String name = validationRuleElement.getLocalName();
        ValidationRuleBuilder builder = (ValidationRuleBuilder)this.validatorRuleBuilders.get(name);
        if (builder == null) {
            throw new Exception("Unknown validation rule \"" + name + "\" specified at " + DomHelper.getLocation(validationRuleElement));
        }
        return builder.build(validationRuleElement);
    }

    public Convertor createConvertor(String dataTypeName, Element convertorElement) throws Exception {
        DatatypeBuilder builder = (DatatypeBuilder)this.datatypeBuilders.get(dataTypeName);
        if (builder == null) {
            throw new Exception("Unknown datatype '" + dataTypeName + "' specified for " + DomHelper.getLocation(convertorElement));
        }
        return builder.buildConvertor(convertorElement);
    }

    public void setDatatypeBuilders(Map datatypeBuilders) {
        this.datatypeBuilders = datatypeBuilders;
    }

    public void setValidatorRuleBuilders(Map validatorRuleBuilders) {
        this.validatorRuleBuilders = validatorRuleBuilders;
    }
}

