/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.serialization;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.HashMap;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.renderer.ExtendableRendererFactory;
import org.apache.cocoon.components.renderer.RendererFactory;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.core.container.spring.logger.LoggerUtils;
import org.apache.cocoon.serialization.AbstractSerializer;
import org.apache.cocoon.util.ClassUtils;
import org.apache.cocoon.util.avalon.CLLoggerWrapper;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.Options;
import org.apache.fop.configuration.ConfigurationParser;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.render.Renderer;
import org.xml.sax.ContentHandler;

public class FOPSerializer
extends AbstractSerializer
implements Configurable,
CacheableProcessingComponent,
Serviceable {
    protected static final RendererFactory factory = ExtendableRendererFactory.getRendererFactoryImplementation();
    protected Driver driver;
    protected Renderer renderer;
    protected String mimetype;
    protected String rendererName;
    protected boolean setContentLength = true;
    protected Logger logger;
    private static boolean configured;
    protected ServiceManager manager;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.logger = new CLLoggerWrapper(LoggerUtils.getChildLogger((ServiceManager)manager, (String)"fop"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configure(Configuration conf) throws ConfigurationException {
        block25: {
            MessageHandler.setScreenLogger((Logger)this.logger);
            Class clazz = FOPSerializer.class;
            synchronized (clazz) {
                if (!configured) {
                    try {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug((Object)"Loading default configuration");
                        }
                        new Options();
                    }
                    catch (Exception e) {
                        this.getLogger().error((Object)"Cannot load default configuration. Proceeding.", (Throwable)e);
                    }
                    configured = true;
                }
            }
            this.setContentLength = conf.getChild("set-content-length").getValueAsBoolean(true);
            String configUrl = conf.getChild("user-config").getAttribute("src", null);
            if (configUrl != null) {
                this.getLogger().warn((Object)"Attribute src of user-config element is deprecated. Provide Cocoon URI as value of the element instead");
                try {
                    configUrl = new File(configUrl).toURL().toExternalForm();
                }
                catch (MalformedURLException e) {
                    this.getLogger().warn((Object)("Can not load config file " + configUrl), (Throwable)e);
                    configUrl = null;
                }
            } else {
                configUrl = conf.getChild("user-config").getValue(null);
            }
            if (configUrl != null) {
                Source configSource = null;
                SourceResolver resolver = null;
                try {
                    try {
                        resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                        configSource = resolver.resolveURI(configUrl);
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug((Object)("Loading configuration from " + configSource.getURI()));
                        }
                        SourceUtil.toSAX((Source)configSource, (ContentHandler)new ConfigurationParser());
                    }
                    catch (Exception e) {
                        this.getLogger().warn((Object)("Cannot load configuration from " + configUrl));
                        throw new ConfigurationException("Cannot load configuration from " + configUrl, (Throwable)e);
                    }
                    Object var7_9 = null;
                    if (resolver == null) break block25;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    if (resolver != null) {
                        resolver.release(configSource);
                        this.manager.release((Object)resolver);
                    }
                    throw throwable;
                }
                resolver.release(configSource);
                this.manager.release((Object)resolver);
            }
        }
        this.mimetype = conf.getAttribute("mime-type");
        Configuration[] parameters = conf.getChildren("parameter");
        for (int i = 0; i < parameters.length; ++i) {
            String name = parameters[i].getAttribute("name");
            if (!"renderer".equals(name)) continue;
            this.rendererName = parameters[i].getAttribute("value");
            try {
                this.renderer = (Renderer)ClassUtils.newInstance((String)this.rendererName);
                continue;
            }
            catch (Exception ex) {
                this.getLogger().error((Object)("Cannot load  class " + this.rendererName), (Throwable)ex);
                throw new ConfigurationException("Cannot load class " + this.rendererName, (Throwable)ex);
            }
        }
        if (this.renderer == null) {
            this.renderer = factory.createRenderer(this.mimetype);
        }
        if (this.renderer == null) {
            throw new ConfigurationException("Could not autodetect renderer for FOPSerializer and no renderer was specified in the sitemap configuration.");
        }
        Configuration confRenderer = conf.getChild("renderer-config");
        if (confRenderer != null && (parameters = confRenderer.getChildren("parameter")).length > 0) {
            HashMap<String, String> rendererOptions = new HashMap<String, String>();
            for (int i = 0; i < parameters.length; ++i) {
                String name = parameters[i].getAttribute("name");
                String value = parameters[i].getAttribute("value");
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("renderer " + String.valueOf(name) + " = " + String.valueOf(value)));
                }
                rendererOptions.put(name, value);
            }
            this.renderer.setOptions(rendererOptions);
        }
    }

    public String getMimeType() {
        return this.mimetype;
    }

    public void setOutputStream(OutputStream out) {
        this.driver = new Driver();
        this.driver.setLogger(this.logger);
        if (this.rendererName == null) {
            this.renderer = factory.createRenderer(this.mimetype);
        } else {
            try {
                this.renderer = (Renderer)ClassUtils.newInstance((String)this.rendererName);
            }
            catch (Exception e) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn((Object)("Cannot load class " + this.rendererName), (Throwable)e);
                }
                throw new CascadingRuntimeException("Cannot load class " + this.rendererName, (Throwable)e);
            }
        }
        this.driver.setRenderer(this.renderer);
        this.driver.setOutputStream(out);
        this.setContentHandler(this.driver.getContentHandler());
    }

    public Serializable getKey() {
        return "1";
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public void recycle() {
        super.recycle();
        this.driver = null;
        this.renderer = null;
    }

    public boolean shouldSetContentLength() {
        return this.setContentLength;
    }
}

