/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.hsqldb;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.cocoon.thread.RunnableManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hsqldb.DatabaseManager;
import org.hsqldb.Server;

public class ServerImpl
implements Runnable {
    private static final boolean DEFAULT_TRACE = false;
    private static final boolean DEFAULT_SILENT = true;
    private static final int DEFAULT_PORT = 9002;
    private static final String CONTEXT_PROTOCOL = "context:/";
    private static final String DEFAULT_DB_NAME = "cocoondb";
    private static final String DEFAULT_DB_PATH = "context://WEB-INF/db";
    private Server hsqlServer = new Server();
    private String daemonThreadPoolName = "daemon";
    private Log logger = LogFactory.getLog(this.getClass());
    private ServletContext servletContext;
    private RunnableManager runnableManager;
    private boolean trace = false;
    private boolean silent = true;
    private int port = 9002;
    private Properties databases;

    public ServerImpl() {
        this.hsqlServer.setLogWriter(null);
        this.hsqlServer.setErrWriter(null);
        this.hsqlServer.setNoSystemExit(true);
        this.databases = new Properties();
        this.databases.setProperty(DEFAULT_DB_NAME, DEFAULT_DB_PATH);
    }

    public Log getLogger() {
        return this.logger;
    }

    public void setLogger(Log l) {
        this.logger = l;
    }

    public Server getServer() {
        return this.hsqlServer;
    }

    public void setThreadPoolName(String name) {
        this.daemonThreadPoolName = name;
    }

    public void setDatabases(Properties p) {
        this.databases = p;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public void setServletContext(ServletContext c) {
        this.servletContext = c;
    }

    public void setRunnableManager(RunnableManager runnableManager) {
        this.runnableManager = runnableManager;
    }

    public void init() {
        if (this.databases == null || this.databases.size() == 0) {
            this.getLogger().warn((Object)"HSQLDB Server is configured, but no databases are configured!");
            this.getLogger().warn((Object)"HSQLDB Server not started.");
            return;
        }
        this.hsqlServer.setSilent(this.silent);
        this.hsqlServer.setTrace(this.trace);
        this.hsqlServer.setPort(this.port);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Configure HSQLDB with port: " + this.hsqlServer.getPort() + ", silent: " + this.hsqlServer.isSilent() + ", trace: " + this.hsqlServer.isTrace()));
        }
        Iterator<Map.Entry<Object, Object>> i = this.databases.entrySet().iterator();
        int index = 0;
        while (i.hasNext()) {
            String dbPath;
            Map.Entry<Object, Object> current = i.next();
            String name = current.getKey().toString();
            String dbCfgPath = current.getValue().toString();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Configuring database " + name + " with path " + dbCfgPath));
            }
            if ((dbPath = dbCfgPath).startsWith(CONTEXT_PROTOCOL)) {
                if ((dbPath = this.servletContext.getRealPath(dbPath.substring(CONTEXT_PROTOCOL.length()))) == null) {
                    throw new IllegalArgumentException("The hsqldb cannot be used inside an unexpanded WAR file. Real path for <" + dbCfgPath + "> is null.");
                }
            } else {
                File directory;
                if (dbPath.startsWith("file:")) {
                    dbPath = dbPath.substring(5);
                }
                if (!(directory = new File(dbPath)).exists()) {
                    throw new IllegalArgumentException("Path for hsqldb database does not exist: " + dbPath);
                }
                if (!directory.isDirectory()) {
                    throw new IllegalArgumentException("Path for hsqldb database does not point to a directory: " + dbPath);
                }
            }
            try {
                this.hsqlServer.setDatabasePath(index, new File(dbPath).getCanonicalPath() + File.separator + name);
                this.hsqlServer.setDatabaseName(index, name);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not get database directory <" + dbPath + ">", e);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Database path for " + name + " is <" + this.hsqlServer.getDatabasePath(index, true) + ">, index " + index));
            }
            ++index;
        }
        this.start();
    }

    public void destroy() {
        this.stop();
    }

    protected void start() {
        this.runnableManager.execute(this.daemonThreadPoolName, (Runnable)this);
    }

    protected void stop() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Shutting down HSQLDB");
        }
        DatabaseManager.closeDatabases((int)1);
        this.hsqlServer.stop();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Shutting down HSQLDB: Done");
        }
    }

    public void run() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Starting " + this.hsqlServer.getProductName() + " " + this.hsqlServer.getProductVersion() + " with parameters:"));
        }
        this.hsqlServer.start();
    }
}

