/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ashwood.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.cayenne.ashwood.graph.ArcIterator;
import org.apache.cayenne.ashwood.graph.DepthFirstSearch;
import org.apache.cayenne.ashwood.graph.DepthFirstStampSearch;
import org.apache.cayenne.ashwood.graph.Digraph;
import org.apache.cayenne.ashwood.graph.DigraphIteration;
import org.apache.cayenne.ashwood.graph.FilterIteration;
import org.apache.cayenne.ashwood.graph.ReversedIteration;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.TruePredicate;

public class StrongConnection<E, V>
implements Iterator<Collection<E>> {
    private DigraphIteration<E, V> digraph;
    private DigraphIteration<E, V> reverseDigraph;
    private DigraphIteration<E, V> filteredDigraph;
    private DepthFirstStampSearch<E> directDfs;
    private DepthFirstSearch<E> reverseDfs;
    private Set<E> seen = new HashSet();
    private Iterator<E> vertexIterator;
    private ArrayStack dfsStack = new ArrayStack();
    private DFSSeenVerticesPredicate reverseDFSFilter = new DFSSeenVerticesPredicate();

    public StrongConnection(DigraphIteration<E, V> digraph) {
        this.digraph = digraph;
        this.filteredDigraph = new FilterIteration<E, V>(digraph, new NotSeenPredicate(), TruePredicate.INSTANCE);
        this.reverseDigraph = new FilterIteration<E, V>(new ReversedIteration<E, V>(digraph), this.reverseDFSFilter, TruePredicate.INSTANCE);
        this.vertexIterator = this.filteredDigraph.vertexIterator();
        this.runDirectDFS();
    }

    @Override
    public boolean hasNext() {
        return !this.dfsStack.isEmpty();
    }

    @Override
    public Collection<E> next() {
        Collection<E> component = this.buildStronglyConnectedComponent();
        if (this.dfsStack.isEmpty()) {
            this.runDirectDFS();
        }
        return component;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Method remove() not supported.");
    }

    public Digraph<Collection<E>, Collection<V>> contract(Digraph<Collection<E>, Collection<V>> contractedDigraph) {
        ArrayList components = new ArrayList();
        CollectionUtils.addAll(components, (Iterator)this);
        HashMap memberToComponent = new HashMap();
        for (Collection c : components) {
            for (Object e : c) {
                memberToComponent.put(e, c);
            }
        }
        for (Collection origin : components) {
            contractedDigraph.addVertex(origin);
            for (Object member : origin) {
                ArcIterator<E, V> k = this.digraph.outgoingIterator(member);
                while (k.hasNext()) {
                    Object arc = k.next();
                    E dst = k.getDestination();
                    if (origin.contains(dst)) continue;
                    Collection destination = (Collection)memberToComponent.get(dst);
                    Collection<V> contractedArc = contractedDigraph.getArc(origin, destination);
                    if (contractedArc == null) {
                        contractedArc = Collections.singletonList(arc);
                        contractedDigraph.putArc(origin, destination, contractedArc);
                        continue;
                    }
                    if (contractedArc.size() == 1) {
                        Collection<V> tmp = contractedArc;
                        contractedArc = new ArrayList<V>();
                        contractedArc.addAll(tmp);
                        contractedDigraph.putArc(origin, destination, contractedArc);
                    }
                    contractedArc.add(arc);
                }
            }
        }
        return contractedDigraph;
    }

    private E nextDFSRoot() {
        return this.vertexIterator.hasNext() ? (E)this.vertexIterator.next() : null;
    }

    private boolean runDirectDFS() {
        this.dfsStack.clear();
        this.reverseDFSFilter.seenVertices.clear();
        E root = this.nextDFSRoot();
        if (root == null) {
            return false;
        }
        if (this.directDfs == null) {
            this.directDfs = new DepthFirstStampSearch<E>(this.filteredDigraph, root);
        } else {
            this.directDfs.reset(root);
        }
        while (this.directDfs.hasNext()) {
            E vertex = this.directDfs.next();
            int stamp = this.directDfs.getStamp();
            if (stamp != 2 && stamp != 3) continue;
            this.dfsStack.push(vertex);
            this.reverseDFSFilter.seenVertices.add(vertex);
        }
        this.seen.addAll((Collection<E>)this.dfsStack);
        return true;
    }

    private Collection<E> buildStronglyConnectedComponent() {
        Object root = this.dfsStack.pop();
        List<Object> component = Collections.singletonList(root);
        boolean singleton = true;
        if (this.reverseDfs == null) {
            this.reverseDfs = new DepthFirstSearch<Object>(this.reverseDigraph, root);
        } else {
            this.reverseDfs.reset(root);
        }
        while (this.reverseDfs.hasNext()) {
            E vertex = this.reverseDfs.next();
            if (vertex == root) continue;
            if (singleton) {
                List<Object> tmp = component;
                component = new ArrayList<Object>();
                component.addAll(tmp);
                singleton = false;
            }
            component.add(vertex);
            this.dfsStack.remove(vertex);
        }
        this.reverseDFSFilter.seenVertices.removeAll(component);
        return component;
    }

    private class NotSeenPredicate
    implements Predicate {
        private NotSeenPredicate() {
        }

        public boolean evaluate(Object vertex) {
            return !StrongConnection.this.seen.contains(vertex);
        }
    }

    private class DFSSeenVerticesPredicate
    implements Predicate {
        private Set<E> seenVertices = new HashSet();

        private DFSSeenVerticesPredicate() {
        }

        public boolean evaluate(Object vertex) {
            return this.seenVertices.contains(vertex);
        }
    }
}

