/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.DbAttributeListener;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;

public class DbAttribute
extends Attribute
implements ConfigurationNode {
    protected int type = Integer.MAX_VALUE;
    protected boolean mandatory;
    protected boolean primaryKey;
    protected boolean generated;
    protected int maxLength = -1;
    protected int scale = -1;
    protected int attributePrecision = -1;

    public DbAttribute() {
    }

    public DbAttribute(String name) {
        super(name);
    }

    public DbAttribute(String name, int type, DbEntity entity) {
        this.setName(name);
        this.setType(type);
        this.setEntity(entity);
    }

    @Override
    public DbEntity getEntity() {
        return (DbEntity)super.getEntity();
    }

    @Override
    public <T> T acceptVisitor(ConfigurationNodeVisitor<T> visitor) {
        return visitor.visitDbAttribute(this);
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<db-attribute name=\"");
        encoder.print(Util.encodeXmlAttribute(this.getName()));
        encoder.print('\"');
        String type = TypesMapping.getSqlNameByType(this.getType());
        if (type != null) {
            encoder.print(" type=\"" + type + '\"');
        }
        if (this.isPrimaryKey()) {
            encoder.print(" isPrimaryKey=\"true\"");
            if (this.isGenerated()) {
                encoder.print(" isGenerated=\"true\"");
            }
        }
        if (this.isMandatory()) {
            encoder.print(" isMandatory=\"true\"");
        }
        if (this.getMaxLength() > 0) {
            encoder.print(" length=\"");
            encoder.print(this.getMaxLength());
            encoder.print('\"');
        }
        if (this.getScale() > 0) {
            encoder.print(" scale=\"");
            encoder.print(this.getScale());
            encoder.print('\"');
        }
        if (this.getAttributePrecision() > 0) {
            encoder.print(" attributePrecision=\"");
            encoder.print(this.getAttributePrecision());
            encoder.print('\"');
        }
        encoder.println("/>");
    }

    public String getAliasedName(String alias) {
        return alias != null ? alias + '.' + this.getName() : this.getName();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isForeignKey() {
        String name = this.getName();
        if (name == null) {
            return false;
        }
        for (DbRelationship relationship : this.getEntity().getRelationships()) {
            for (DbJoin join : relationship.getJoins()) {
                DbAttribute target;
                if (!name.equals(join.getSourceName()) || (target = join.getTarget()) == null || !target.isPrimaryKey()) continue;
                return true;
            }
        }
        return false;
    }

    public void setPrimaryKey(boolean primaryKey) {
        if (this.primaryKey != primaryKey) {
            this.primaryKey = primaryKey;
            DbEntity e = this.getEntity();
            if (e instanceof DbAttributeListener) {
                ((DbAttributeListener)e).dbAttributeChanged(new AttributeEvent((Object)this, this, e));
            }
        }
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public void setGenerated(boolean generated) {
        if (this.generated != generated) {
            this.generated = generated;
            DbEntity e = this.getEntity();
            if (e instanceof DbAttributeListener) {
                ((DbAttributeListener)e).dbAttributeChanged(new AttributeEvent((Object)this, this, e));
            }
        }
    }

    public int getAttributePrecision() {
        return this.attributePrecision;
    }

    public void setAttributePrecision(int attributePrecision) {
        this.attributePrecision = attributePrecision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public String toString() {
        String res = "DbAttr: ";
        String type = TypesMapping.getSqlNameByType(this.getType());
        res = res + (type != null ? type : "type(" + this.getType() + ")");
        res = res + " " + this.name;
        if (this.scale > -1 || this.attributePrecision > -1) {
            res = res + "[" + this.scale + ", " + this.attributePrecision + "]";
        }
        if (this.maxLength > -1) {
            res = res + "[" + this.maxLength + "]";
        }
        if (this.primaryKey) {
            res = res + " Primary Key ";
        } else if (this.mandatory) {
            res = res + " Mandatory ";
        }
        return res;
    }
}

