/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbimport;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.SchemaContainer;

public class ReverseEngineering
extends SchemaContainer
implements Serializable {
    private Boolean skipRelationshipsLoading;
    private Boolean skipPrimaryKeyLoading;
    private String defaultPackage;
    private boolean forceDataMapCatalog;
    private boolean forceDataMapSchema;
    private String meaningfulPkTables;
    private String namingStrategy = "org.apache.cayenne.dbsync.naming.DefaultObjectNameGenerator";
    private String stripFromTableNames = "";
    private boolean usePrimitives = true;
    private boolean useJava7Types = false;
    private final Collection<String> tableTypes = new LinkedList<String>();
    private final Collection<Catalog> catalogCollection = new LinkedList<Catalog>();

    public Boolean getSkipRelationshipsLoading() {
        return this.skipRelationshipsLoading;
    }

    public void setSkipRelationshipsLoading(Boolean skipRelationshipsLoading) {
        this.skipRelationshipsLoading = skipRelationshipsLoading;
    }

    public Boolean getSkipPrimaryKeyLoading() {
        return this.skipPrimaryKeyLoading;
    }

    public void setSkipPrimaryKeyLoading(Boolean skipPrimaryKeyLoading) {
        this.skipPrimaryKeyLoading = skipPrimaryKeyLoading;
    }

    public Collection<Catalog> getCatalogs() {
        return this.catalogCollection;
    }

    public String[] getTableTypes() {
        return this.tableTypes.toArray(new String[this.tableTypes.size()]);
    }

    public void setTableTypes(Collection<String> tableTypes) {
        this.tableTypes.addAll(tableTypes);
    }

    public void addTableType(String type) {
        this.tableTypes.add(type);
    }

    public void addCatalog(Catalog catalog) {
        this.catalogCollection.add(catalog);
    }

    @Override
    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("ReverseEngineering: ").append("\n");
        if (!ReverseEngineering.isBlank(this.catalogCollection)) {
            for (Catalog catalog : this.catalogCollection) {
                catalog.toString(res, "  ");
            }
        }
        if (this.skipRelationshipsLoading != null && this.skipRelationshipsLoading.booleanValue()) {
            res.append("\n        Skip Relationships Loading");
        }
        if (this.skipPrimaryKeyLoading != null && this.skipPrimaryKeyLoading.booleanValue()) {
            res.append("\n        Skip PrimaryKey Loading");
        }
        return super.toString(res, "  ").toString();
    }

    public String getDefaultPackage() {
        return this.defaultPackage;
    }

    public boolean isForceDataMapCatalog() {
        return this.forceDataMapCatalog;
    }

    public boolean isForceDataMapSchema() {
        return this.forceDataMapSchema;
    }

    public String getMeaningfulPkTables() {
        return this.meaningfulPkTables;
    }

    public String getNamingStrategy() {
        return this.namingStrategy;
    }

    public String getStripFromTableNames() {
        return this.stripFromTableNames;
    }

    public boolean isUsePrimitives() {
        return this.usePrimitives;
    }

    public boolean isUseJava7Types() {
        return this.useJava7Types;
    }

    public void setDefaultPackage(String defaultPackage) {
        this.defaultPackage = defaultPackage;
    }

    public void setForceDataMapCatalog(boolean forceDataMapCatalog) {
        this.forceDataMapCatalog = forceDataMapCatalog;
    }

    public void setForceDataMapSchema(boolean forceDataMapSchema) {
        this.forceDataMapSchema = forceDataMapSchema;
    }

    public void setMeaningfulPkTables(String meaningfulPkTables) {
        this.meaningfulPkTables = meaningfulPkTables;
    }

    public void setNamingStrategy(String namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public void setStripFromTableNames(String stripFromTableNames) {
        this.stripFromTableNames = stripFromTableNames;
    }

    public void setUsePrimitives(boolean usePrimitives) {
        this.usePrimitives = usePrimitives;
    }

    public void setUseJava7Types(boolean useJava7Types) {
        this.useJava7Types = useJava7Types;
    }
}

