/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.task.utils.bes;

import de.fzj.unicore.uas.client.FileTransferClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.client.UFTPFileTransferClient;
import de.fzj.unicore.uas.fts.FiletransferOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.airavata.gfac.impl.task.utils.bes.FileTransferBase;
import org.apache.airavata.gfac.impl.task.utils.bes.Mode;
import org.unigrids.services.atomic.types.ProtocolType;

public class FileUploader
extends FileTransferBase {
    public FileUploader(String from, String to, Mode mode) throws FileNotFoundException {
        this(from, to, mode, true);
    }

    public FileUploader(String from, String to, Mode mode, boolean failOnError) throws FileNotFoundException {
        this.to = to;
        this.from = from;
        this.mode = mode;
        this.failOnError = failOnError;
        this.checkOK();
    }

    @Override
    public String getFrom() {
        return this.from;
    }

    @Override
    public String getTo() {
        return this.to;
    }

    public void perform(StorageClient sms) throws Exception {
        File fileSpec = new File(this.from);
        boolean hasWildCards = false;
        boolean isDirectory = fileSpec.isDirectory();
        File[] fileset = null;
        if (!isDirectory) {
            hasWildCards = this.hasWildCards(fileSpec);
        }
        this.chosenProtocol = sms.findSupportedProtocol(this.preferredProtocols.toArray(new ProtocolType.Enum[this.preferredProtocols.size()]));
        Map<String, String> extraParameters = this.makeExtraParameters(this.chosenProtocol);
        if (!hasWildCards && !isDirectory) {
            this.uploadFile(fileSpec, this.to, sms, this.chosenProtocol, extraParameters);
            return;
        }
        fileset = hasWildCards ? this.resolveWildCards(fileSpec) : fileSpec.listFiles();
        if (!this.isValidDirectory(this.to, sms)) {
            throw new IOException("The specified remote target '" + this.to + "' is not a directory");
        }
        if (this.to == null) {
            this.to = "/";
        }
        String target = isDirectory ? this.to + "/" + fileSpec.getName() : this.to;
        sms.createDirectory(target);
        this.uploadFiles(fileset, target, sms, this.chosenProtocol, extraParameters);
    }

    private void uploadFiles(File[] files, String remoteDirectory, StorageClient sms, ProtocolType.Enum protocol, Map<String, String> extraParameters) throws Exception {
        for (File localFile : files) {
            String target = remoteDirectory + "/" + localFile.getName();
            if (localFile.isDirectory()) {
                if (!this.recurse) {
                    System.out.println("Skipping directory " + localFile.getAbsolutePath());
                    continue;
                }
                File[] fileset = localFile.listFiles();
                sms.createDirectory(target);
                this.uploadFiles(fileset, target, sms, protocol, extraParameters);
                continue;
            }
            this.uploadFile(localFile, target, sms, protocol, extraParameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFile(File localFile, String remotePath, StorageClient sms, ProtocolType.Enum protocol, Map<String, String> extraParameters) throws Exception {
        long startTime = System.currentTimeMillis();
        FileInputStream is = null;
        FileTransferClient ftc = null;
        try {
            if (remotePath == null) {
                remotePath = "/" + localFile.getName();
            } else if (remotePath.endsWith("/")) {
                remotePath = remotePath + localFile.getName();
            }
            System.out.println("Uploading local file '" + localFile.getAbsolutePath() + "' -> '" + sms.getUrl() + "#" + remotePath + "'");
            is = new FileInputStream(localFile.getAbsolutePath());
            boolean append = Mode.append.equals((Object)this.mode);
            ftc = sms.getImport(remotePath, append, extraParameters, new ProtocolType.Enum[]{protocol});
            this.configure(ftc, extraParameters);
            if (append) {
                ftc.setAppend(true);
            }
            String url = ftc.getUrl();
            System.out.println("File transfer URL : " + url);
            if (ftc instanceof FiletransferOptions.IMonitorable) {
                long size = localFile.length();
                if (this.isRange()) {
                    size = this.getRangeSize();
                }
            }
            if (this.isRange()) {
                System.out.println("Byte range: " + this.startByte + " - " + (this.getRangeSize() > 0L ? this.endByte : ""));
                for (long skipped = 0L; skipped < this.startByte; skipped += is.skip(this.startByte)) {
                }
                ftc.writeAllData((InputStream)is, this.endByte - this.startByte + 1L);
            } else {
                ftc.writeAllData((InputStream)is);
            }
            this.copyProperties(localFile, sms, remotePath);
        }
        finally {
            if (ftc != null) {
                try {
                    ftc.destroy();
                }
                catch (Exception append) {}
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception append) {}
        }
        if (this.timing) {
            long duration = System.currentTimeMillis() - startTime;
            double rate = (double)localFile.length() / (double)duration;
            System.out.println("Rate: " + rate + " kB/sec.");
        }
    }

    private void copyProperties(File sourceFile, StorageClient sms, String target) throws Exception {
        boolean x = sourceFile.canExecute();
        try {
            if (x) {
                sms.changePermissions(target, true, true, x);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkOK() throws FileNotFoundException {
        File[] files;
        if (!this.failOnError) {
            return;
        }
        File orig = new File(this.from);
        if (!orig.isAbsolute()) {
            orig = new File(System.getProperty("user.dir"), this.from);
        }
        if ((files = this.resolveWildCards(orig)) == null) {
            throw new FileNotFoundException("Local import '" + this.from + "' does not exist.");
        }
        for (File f : files) {
            if (f.exists()) continue;
            throw new FileNotFoundException("Local import '" + this.from + "' does not exist.");
        }
    }

    private void configure(FileTransferClient ftc, Map<String, String> params) {
        if (ftc instanceof UFTPFileTransferClient) {
            UFTPFileTransferClient u = (UFTPFileTransferClient)ftc;
            String secret = params.get("uftp.secret");
            u.setSecret(secret);
        }
    }
}

