/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.security.userstore;

import org.apache.airavata.security.UserStore;
import org.apache.airavata.security.UserStoreException;
import org.apache.airavata.security.util.PasswordDigester;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.realm.ldap.JndiLdapContextFactory;
import org.apache.shiro.realm.ldap.JndiLdapRealm;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class LDAPUserStore
implements UserStore {
    private JndiLdapRealm ldapRealm;
    protected static Logger log = LoggerFactory.getLogger(LDAPUserStore.class);
    private PasswordDigester passwordDigester;

    @Override
    public boolean authenticate(String userName, Object credentials) throws UserStoreException {
        AuthenticationInfo authenticationInfo;
        UsernamePasswordToken authenticationToken = new UsernamePasswordToken(userName, this.passwordDigester.getPasswordHashValue((String)credentials));
        try {
            authenticationInfo = this.ldapRealm.getAuthenticationInfo((AuthenticationToken)authenticationToken);
        }
        catch (AuthenticationException e) {
            log.warn(e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
        return authenticationInfo != null;
    }

    @Override
    public boolean authenticate(Object credentials) throws UserStoreException {
        log.error("LDAP user store only supports authenticating with user name and password.");
        throw new NotImplementedException();
    }

    @Override
    public void configure(Node specificConfigurationNode) throws UserStoreException {
        Node configurationNode = null;
        if (specificConfigurationNode != null) {
            NodeList nodeList = specificConfigurationNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node n = nodeList.item(i);
                if (n.getNodeType() != 1) continue;
                configurationNode = n;
            }
        }
        String url = null;
        String systemUser = null;
        String systemUserPassword = null;
        String userTemplate = null;
        String passwordHashMethod = null;
        if (configurationNode != null) {
            NodeList nodeList = configurationNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node n = nodeList.item(i);
                if (n.getNodeType() != 1) continue;
                Element element = (Element)n;
                if (element.getNodeName().equals("url")) {
                    url = element.getFirstChild().getNodeValue();
                    continue;
                }
                if (element.getNodeName().equals("systemUser")) {
                    systemUser = element.getFirstChild().getNodeValue();
                    continue;
                }
                if (element.getNodeName().equals("systemUserPassword")) {
                    systemUserPassword = element.getFirstChild().getNodeValue();
                    continue;
                }
                if (element.getNodeName().equals("userDNTemplate")) {
                    userTemplate = element.getFirstChild().getNodeValue();
                    continue;
                }
                if (!element.getNodeName().equals("passwordHashMethod")) continue;
                passwordHashMethod = element.getFirstChild().getNodeValue();
            }
        }
        this.passwordDigester = new PasswordDigester(passwordHashMethod);
        this.initializeLDAP(url, systemUser, systemUserPassword, userTemplate);
    }

    protected void initializeLDAP(String ldapUrl, String systemUser, String systemUserPassword, String userNameTemplate) {
        JndiLdapContextFactory jndiLdapContextFactory = new JndiLdapContextFactory();
        jndiLdapContextFactory.setUrl(ldapUrl);
        jndiLdapContextFactory.setSystemUsername(systemUser);
        jndiLdapContextFactory.setSystemPassword(systemUserPassword);
        this.ldapRealm = new JndiLdapRealm();
        this.ldapRealm.setContextFactory((LdapContextFactory)jndiLdapContextFactory);
        this.ldapRealm.setUserDnTemplate(userNameTemplate);
        this.ldapRealm.init();
    }
}

