/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.registry.core.app.catalog.model.JobManagerCommand;
import org.apache.airavata.registry.core.app.catalog.model.JobManagerCommand_PK;
import org.apache.airavata.registry.core.app.catalog.model.ResourceJobManager;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.ResourceJobManagerResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManagerCommandResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(JobManagerCommandResource.class);
    private String resourceJobManagerId;
    private ResourceJobManagerResource resourceJobManagerResource;
    private String commandType;
    private String command;

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("JobManagerCommand", new Object[0][]);
            generator.setParameter("resourceJobManagerId", ids.get("resourceJobManagerId"));
            generator.setParameter("commandType", ids.get("commandType"));
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("JobManagerCommand", new Object[0][]);
            generator.setParameter("resourceJobManagerId", ids.get("resourceJobManagerId"));
            generator.setParameter("commandType", ids.get("commandType"));
            Query q = generator.selectQuery(em);
            JobManagerCommand jobManagerCommand = (JobManagerCommand)q.getSingleResult();
            JobManagerCommandResource jobManagerCommandResource = (JobManagerCommandResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.JOB_MANAGER_COMMAND, jobManagerCommand);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            JobManagerCommandResource jobManagerCommandResource2 = jobManagerCommandResource;
            return jobManagerCommandResource2;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> jobManagerCommandResources = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("JobManagerCommand", new Object[0][]);
            if (fieldName.equals("resourceJobManagerId") || fieldName.equals("commandType") || fieldName.equals("command")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    JobManagerCommand jobManagerCommand = (JobManagerCommand)result;
                    JobManagerCommandResource jobManagerCommandResource = (JobManagerCommandResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.JOB_MANAGER_COMMAND, jobManagerCommand);
                    jobManagerCommandResources.add(jobManagerCommandResource);
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Job Manager Command Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Job Manager Command Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return jobManagerCommandResources;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        ArrayList<String> jobManagerCommandResourceIDs = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("JobManagerCommand", new Object[0][]);
            if (fieldName.equals("resourceJobManagerId") || fieldName.equals("commandType") || fieldName.equals("command")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    JobManagerCommand jobManagerCommand = (JobManagerCommand)result;
                    JobManagerCommandResource jobManagerCommandResource = (JobManagerCommandResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.JOB_MANAGER_COMMAND, jobManagerCommand);
                    jobManagerCommandResourceIDs.add(jobManagerCommandResource.getResourceJobManagerId());
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Job Manager Command Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Job Manager Command Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return jobManagerCommandResourceIDs;
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            JobManagerCommand existingJobManagerCommand = (JobManagerCommand)em.find(JobManagerCommand.class, (Object)new JobManagerCommand_PK(this.resourceJobManagerId, this.commandType));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            JobManagerCommand jobManagerCommand = existingJobManagerCommand == null ? new JobManagerCommand() : existingJobManagerCommand;
            jobManagerCommand.setResourceJobManagerId(this.getResourceJobManagerId());
            ResourceJobManager resourceJobManager = (ResourceJobManager)em.find(ResourceJobManager.class, (Object)this.getResourceJobManagerId());
            jobManagerCommand.setResourceJobManager(resourceJobManager);
            jobManagerCommand.setCommandType(this.getCommandType());
            jobManagerCommand.setCommand(this.getCommand());
            if (existingJobManagerCommand == null) {
                em.persist((Object)jobManagerCommand);
            } else {
                em.merge((Object)jobManagerCommand);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            JobManagerCommand jobManagerCommand = (JobManagerCommand)em.find(JobManagerCommand.class, (Object)new JobManagerCommand_PK((String)ids.get("resourceJobManagerId"), (String)ids.get("commandType")));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = jobManagerCommand != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getResourceJobManagerId() {
        return this.resourceJobManagerId;
    }

    public ResourceJobManagerResource getResourceJobManagerResource() {
        return this.resourceJobManagerResource;
    }

    public String getCommandType() {
        return this.commandType;
    }

    public String getCommand() {
        return this.command;
    }

    public void setResourceJobManagerId(String resourceJobManagerId) {
        this.resourceJobManagerId = resourceJobManagerId;
    }

    public void setResourceJobManagerResource(ResourceJobManagerResource resourceJobManagerResource) {
        this.resourceJobManagerResource = resourceJobManagerResource;
    }

    public void setCommandType(String commandType) {
        this.commandType = commandType;
    }

    public void setCommand(String command) {
        this.command = command;
    }
}

