/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.common;

import java.io.File;
import java.util.regex.Pattern;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.config.UserStoreConfigXMLProcessor;

public class UserStoreDeploymentManager {
    private static Log log = LogFactory.getLog(UserStoreDeploymentManager.class);

    public void deploy(String absoluteFilePath) throws DeploymentException {
        UserStoreConfigXMLProcessor userStoreXMLProcessor = new UserStoreConfigXMLProcessor(absoluteFilePath);
        File userMgtConfigFile = new File(absoluteFilePath);
        try {
            RealmConfiguration realmConfiguration = userStoreXMLProcessor.buildUserStoreConfigurationFromFile();
            UserRealm userRealm = (UserRealm)CarbonContext.getThreadLocalCarbonContext().getUserRealm();
            AbstractUserStoreManager primaryUSM = null;
            String pattern = Pattern.quote(System.getProperty("file.separator"));
            String[] filePathSegments = absoluteFilePath.split(pattern);
            if (filePathSegments[filePathSegments.length - 2].equals("userstores")) {
                if (filePathSegments[filePathSegments.length - 4].equals("tenants")) {
                    realmConfiguration.setTenantId(CarbonContext.getThreadLocalCarbonContext().getTenantId());
                    this.setSecondaryUserStore(userRealm.getRealmConfiguration(), realmConfiguration);
                    primaryUSM = (AbstractUserStoreManager)userRealm.getUserStoreManager();
                    primaryUSM.addSecondaryUserStoreManager(realmConfiguration, userRealm);
                } else {
                    this.setSecondaryUserStore(userRealm.getRealmConfiguration(), realmConfiguration);
                    primaryUSM = (AbstractUserStoreManager)userRealm.getUserStoreManager();
                    primaryUSM.addSecondaryUserStoreManager(realmConfiguration, userRealm);
                }
                log.info((Object)("Realm configuration of tenant:" + CarbonContext.getCurrentContext().getTenantId() + "  modified with " + absoluteFilePath));
            }
        }
        catch (Exception ex) {
            throw new DeploymentException("The deployment of " + userMgtConfigFile.getName() + " is not valid.", (Throwable)ex);
        }
    }

    private void setSecondaryUserStore(RealmConfiguration parent, RealmConfiguration child) {
        String parentDomain = parent.getUserStoreProperty("DomainName");
        String addingDomain = child.getUserStoreProperty("DomainName");
        if (parentDomain == null) {
            return;
        }
        while (parent.getSecondaryRealmConfig() != null) {
            if (parentDomain.equals(addingDomain)) {
                return;
            }
            parent = parent.getSecondaryRealmConfig();
            parentDomain = parent.getUserStoreProperty("DomainName");
        }
        if (parentDomain.equals(addingDomain)) {
            return;
        }
        parent.setSecondaryRealmConfig(child);
    }

    public void undeploy(String fileName) throws DeploymentException {
        String pattern = Pattern.quote(System.getProperty("file.separator"));
        String[] fileNames = fileName.split(pattern);
        String domainName = fileNames[fileNames.length - 1].replace(".xml", "").replace("_", ".");
        Boolean isDisabled = false;
        try {
            int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
            org.wso2.carbon.user.api.UserRealm tenantRealm = CarbonContext.getThreadLocalCarbonContext().getUserRealm();
            RealmConfiguration realmConfig = tenantRealm.getRealmConfiguration();
            AbstractUserStoreManager userStoreManager = (AbstractUserStoreManager)tenantRealm.getUserStoreManager();
            while (realmConfig.getSecondaryRealmConfig() != null) {
                RealmConfiguration secondaryRealm = realmConfig.getSecondaryRealmConfig();
                if (secondaryRealm.getUserStoreProperty("DomainName").equalsIgnoreCase(domainName)) {
                    String disabled = secondaryRealm.getUserStoreProperty("Disabled");
                    if (disabled != null) {
                        isDisabled = Boolean.parseBoolean(disabled);
                    }
                    realmConfig.setSecondaryRealmConfig(secondaryRealm.getSecondaryRealmConfig());
                    log.info((Object)("User store: " + domainName + " of tenant:" + tenantId + " is removed from realm chain."));
                    break;
                }
                realmConfig = realmConfig.getSecondaryRealmConfig();
            }
            if (!isDisabled.booleanValue()) {
                userStoreManager.removeSecondaryUserStoreManager(domainName);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage());
            throw new DeploymentException("Error occurred at undeploying " + domainName + " from tenant:" + CarbonContext.getCurrentContext().getTenantId(), (Throwable)ex);
        }
    }

    public RealmConfiguration getUserStoreConfiguration(String absoluteFilePath) throws UserStoreException {
        UserStoreConfigXMLProcessor userStoreXMLProcessor = new UserStoreConfigXMLProcessor(absoluteFilePath);
        return userStoreXMLProcessor.buildUserStoreConfigurationFromFile();
    }
}

