/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.summary.summarizers;

import com.google.common.math.IntMath;
import java.math.RoundingMode;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.accumulo.core.client.summary.Summarizer;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;

public class EntryLengthSummarizer
implements Summarizer {
    private static void merge(String key, BiFunction<Long, Long, Long> mergeFunc, Map<String, Long> stats1, Map<String, Long> stats2) {
        Long mergeVal = stats2.get(key);
        if (mergeVal != null) {
            stats1.merge(key, mergeVal, mergeFunc);
        }
    }

    private static void merge(String prefix, Map<String, Long> stats1, Map<String, Long> stats2) {
        EntryLengthSummarizer.merge(prefix + ".min", Long::min, stats1, stats2);
        EntryLengthSummarizer.merge(prefix + ".max", Long::max, stats1, stats2);
        EntryLengthSummarizer.merge(prefix + ".sum", Long::sum, stats1, stats2);
        for (int i = 0; i < 32; ++i) {
            EntryLengthSummarizer.merge(prefix + ".logHist." + i, Long::sum, stats1, stats2);
        }
    }

    @Override
    public Summarizer.Collector collector(SummarizerConfiguration sc) {
        return new Summarizer.Collector(){
            private LengthStats keyStats = new LengthStats();
            private LengthStats rowStats = new LengthStats();
            private LengthStats familyStats = new LengthStats();
            private LengthStats qualifierStats = new LengthStats();
            private LengthStats visibilityStats = new LengthStats();
            private LengthStats valueStats = new LengthStats();
            private long total = 0L;

            @Override
            public void accept(Key k, Value v) {
                this.keyStats.accept(k.getLength());
                this.rowStats.accept(k.getRowData().length());
                this.familyStats.accept(k.getColumnFamilyData().length());
                this.qualifierStats.accept(k.getColumnQualifierData().length());
                this.visibilityStats.accept(k.getColumnVisibilityData().length());
                this.valueStats.accept(v.getSize());
                ++this.total;
            }

            @Override
            public void summarize(Summarizer.StatisticConsumer sc) {
                this.keyStats.summarize("key", sc);
                this.rowStats.summarize("row", sc);
                this.familyStats.summarize("family", sc);
                this.qualifierStats.summarize("qualifier", sc);
                this.visibilityStats.summarize("visibility", sc);
                this.valueStats.summarize("value", sc);
                sc.accept("total", this.total);
            }
        };
    }

    @Override
    public Summarizer.Combiner combiner(SummarizerConfiguration sc) {
        return (stats1, stats2) -> {
            EntryLengthSummarizer.merge("key", stats1, stats2);
            EntryLengthSummarizer.merge("row", stats1, stats2);
            EntryLengthSummarizer.merge("family", stats1, stats2);
            EntryLengthSummarizer.merge("qualifier", stats1, stats2);
            EntryLengthSummarizer.merge("visibility", stats1, stats2);
            EntryLengthSummarizer.merge("value", stats1, stats2);
            stats1.merge("total", (Long)stats2.get("total"), Long::sum);
        };
    }

    private static class LengthStats {
        private long min = Long.MAX_VALUE;
        private long max = Long.MIN_VALUE;
        private long sum = 0L;
        private long[] counts = new long[32];

        private LengthStats() {
        }

        private void accept(int length) {
            if ((long)length < this.min) {
                this.min = length;
            }
            if ((long)length > this.max) {
                this.max = length;
            }
            this.sum += (long)length;
            int idx = length == 0 ? 0 : IntMath.log2((int)length, (RoundingMode)RoundingMode.HALF_UP);
            int n = idx;
            this.counts[n] = this.counts[n] + 1L;
        }

        void summarize(String prefix, Summarizer.StatisticConsumer sc) {
            sc.accept(prefix + ".min", this.min != Long.MAX_VALUE ? this.min : 0L);
            sc.accept(prefix + ".max", this.max != Long.MIN_VALUE ? this.max : 0L);
            sc.accept(prefix + ".sum", this.sum);
            for (int i = 0; i < this.counts.length; ++i) {
                if (this.counts[i] <= 0L) continue;
                sc.accept(prefix + ".logHist." + i, this.counts[i]);
            }
        }
    }
}

