/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class ItemFactoryMap<I, P>
implements Map<Function<P, I>, I> {
    protected final HashMap<Function<P, I>, I> itemMap;
    protected final P param;

    public ItemFactoryMap(P param) {
        this(param, 0);
    }

    public ItemFactoryMap(P param, int capacity) {
        this.itemMap = new HashMap(capacity);
        this.param = param;
    }

    public I getItem(Function<P, I> factory) {
        I item = this.itemMap.get(factory);
        if (item == null) {
            item = factory.apply(this.param);
            this.itemMap.put(factory, item);
        }
        return item;
    }

    @Override
    public I get(Object o) {
        if (o instanceof Function) {
            return this.getItem((Function)o);
        }
        return null;
    }

    @Override
    public int size() {
        return this.itemMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.itemMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.itemMap.containsKey(o);
    }

    @Override
    public I put(Function<P, I> factory, I i) {
        return this.itemMap.put(factory, i);
    }

    @Override
    public void putAll(Map<? extends Function<P, I>, ? extends I> map) {
        this.itemMap.putAll(map);
    }

    @Override
    public I remove(Object o) {
        return this.itemMap.remove(o);
    }

    @Override
    public void clear() {
        this.itemMap.clear();
    }

    @Override
    public boolean containsValue(Object o) {
        return this.itemMap.containsValue(o);
    }

    @Override
    public Set<Function<P, I>> keySet() {
        return this.itemMap.keySet();
    }

    @Override
    public Collection<I> values() {
        return this.itemMap.values();
    }

    @Override
    public Set<Map.Entry<Function<P, I>, I>> entrySet() {
        return this.itemMap.entrySet();
    }
}

