/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.tree.impl;

import com.google.common.base.MoreObjects;

public class DocumentTreeResult<V> {
    public static final DocumentTreeResult NOOP = new DocumentTreeResult<Object>(Status.NOOP, null);
    public static final DocumentTreeResult WRITE_LOCK = new DocumentTreeResult<Object>(Status.WRITE_LOCK, null);
    public static final DocumentTreeResult INVALID_PATH = new DocumentTreeResult<Object>(Status.INVALID_PATH, null);
    public static final DocumentTreeResult ILLEGAL_MODIFICATION = new DocumentTreeResult<Object>(Status.ILLEGAL_MODIFICATION, null);
    private final Status status;
    private final V result;

    public static <V> DocumentTreeResult<V> ok(V result) {
        return new DocumentTreeResult<V>(Status.OK, result);
    }

    public static <V> DocumentTreeResult<V> writeLock() {
        return WRITE_LOCK;
    }

    public static <V> DocumentTreeResult<V> invalidPath() {
        return INVALID_PATH;
    }

    public static <V> DocumentTreeResult<V> illegalModification() {
        return ILLEGAL_MODIFICATION;
    }

    public DocumentTreeResult(Status status, V result) {
        this.status = status;
        this.result = result;
    }

    public Status status() {
        return this.status;
    }

    public V result() {
        return this.result;
    }

    public boolean updated() {
        return this.status == Status.OK;
    }

    public boolean created() {
        return this.updated() && this.result == null;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("status", (Object)this.status).add("value", this.result).toString();
    }

    public static enum Status {
        OK,
        NOOP,
        WRITE_LOCK,
        INVALID_PATH,
        ILLEGAL_MODIFICATION;

    }
}

