/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.profile;

import io.atomix.core.AtomixConfig;
import io.atomix.core.profile.DataGridProfileBuilder;
import io.atomix.core.profile.DataGridProfileConfig;
import io.atomix.core.profile.Profile;
import io.atomix.primitive.partition.MemberGroupStrategy;
import io.atomix.primitive.partition.PartitionGroupConfig;
import io.atomix.protocols.backup.partition.PrimaryBackupPartitionGroupConfig;

public class DataGridProfile
implements Profile {
    public static final Type TYPE = new Type();
    private final DataGridProfileConfig config;

    public static DataGridProfileBuilder builder() {
        return new DataGridProfileBuilder();
    }

    DataGridProfile() {
        this(new DataGridProfileConfig());
    }

    DataGridProfile(int numPartitions) {
        this(new DataGridProfileConfig().setPartitions(numPartitions));
    }

    DataGridProfile(DataGridProfileConfig config) {
        this.config = config;
    }

    public DataGridProfileConfig config() {
        return this.config;
    }

    @Override
    public void configure(AtomixConfig config) {
        if (config.getManagementGroup() == null) {
            config.setManagementGroup((PartitionGroupConfig<?>)((PrimaryBackupPartitionGroupConfig)((PrimaryBackupPartitionGroupConfig)new PrimaryBackupPartitionGroupConfig().setName(this.config.getManagementGroup())).setPartitions(1)).setMemberGroupStrategy(MemberGroupStrategy.RACK_AWARE));
        }
        config.addPartitionGroup((PartitionGroupConfig)((PrimaryBackupPartitionGroupConfig)((PrimaryBackupPartitionGroupConfig)new PrimaryBackupPartitionGroupConfig().setName(this.config.getDataGroup())).setPartitions(this.config.getPartitions())).setMemberGroupStrategy(MemberGroupStrategy.RACK_AWARE));
    }

    public static class Type
    implements Profile.Type<DataGridProfileConfig> {
        private static final String NAME = "data-grid";

        public String name() {
            return NAME;
        }

        public DataGridProfileConfig newConfig() {
            return new DataGridProfileConfig();
        }

        @Override
        public Profile newProfile(DataGridProfileConfig config) {
            return new DataGridProfile(config);
        }
    }
}

