/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.collection.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atomix.core.collection.AsyncDistributedCollection;
import io.atomix.core.collection.CollectionEvent;
import io.atomix.core.collection.CollectionEventListener;
import io.atomix.core.collection.impl.CollectionUpdateResult;
import io.atomix.core.collection.impl.DistributedCollectionClient;
import io.atomix.core.collection.impl.DistributedCollectionService;
import io.atomix.core.iterator.AsyncIterator;
import io.atomix.core.iterator.impl.IterableService;
import io.atomix.core.iterator.impl.PartitionedProxyIterator;
import io.atomix.primitive.AbstractAsyncPrimitive;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.PrimitiveRegistry;
import io.atomix.primitive.PrimitiveState;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.event.Event;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public abstract class PartitionedDistributedCollectionProxy<A extends AsyncDistributedCollection<String>, S extends DistributedCollectionService<String>>
extends AbstractAsyncPrimitive<A, S>
implements AsyncDistributedCollection<String>,
DistributedCollectionClient<String> {
    private final Map<CollectionEventListener<String>, Executor> eventListeners = Maps.newConcurrentMap();

    public PartitionedDistributedCollectionProxy(ProxyClient<S> client, PrimitiveRegistry registry) {
        super(client, registry);
    }

    @Override
    public void onEvent(CollectionEvent<String> event) {
        this.eventListeners.forEach((listener, executor) -> executor.execute(() -> listener.event((Event)event)));
    }

    @Override
    public CompletableFuture<Integer> size() {
        return this.getProxyClient().applyAll(service -> service.size()).thenApply(results -> results.reduce(Math::addExact).orElse(0));
    }

    @Override
    public CompletableFuture<Boolean> isEmpty() {
        return this.getProxyClient().applyAll(service -> service.isEmpty()).thenApply(results -> results.reduce(Boolean::logicalAnd).orElse(true));
    }

    @Override
    public CompletableFuture<Boolean> add(String element) {
        return this.getProxyClient().applyBy(element, service -> service.add(element)).thenCompose(result -> this.checkLocked((CollectionUpdateResult)result));
    }

    @Override
    public CompletableFuture<Boolean> remove(String element) {
        return this.getProxyClient().applyBy(element, service -> service.remove(element)).thenCompose(result -> this.checkLocked((CollectionUpdateResult)result));
    }

    @Override
    public CompletableFuture<Boolean> contains(String element) {
        return this.getProxyClient().applyBy(element, service -> service.contains(element));
    }

    @Override
    public CompletableFuture<Boolean> addAll(Collection<? extends String> c) {
        HashMap partitions = Maps.newHashMap();
        c.forEach(key -> partitions.computeIfAbsent(this.getProxyClient().getPartitionId(key), k -> Lists.newArrayList()).add(key));
        return Futures.allOf(partitions.entrySet().stream().map(entry -> this.getProxyClient().applyOn((PartitionId)entry.getKey(), service -> service.addAll((Collection)entry.getValue())).thenCompose(result -> this.checkLocked((CollectionUpdateResult)result))).collect(Collectors.toList())).thenApply(results -> results.stream().reduce(Boolean::logicalOr).orElse(false));
    }

    @Override
    public CompletableFuture<Boolean> containsAll(Collection<? extends String> c) {
        HashMap partitions = Maps.newHashMap();
        c.forEach(key -> partitions.computeIfAbsent(this.getProxyClient().getPartitionId(key), k -> Lists.newArrayList()).add(key));
        return Futures.allOf(partitions.entrySet().stream().map(entry -> this.getProxyClient().applyOn((PartitionId)entry.getKey(), service -> service.containsAll((Collection)entry.getValue()))).collect(Collectors.toList())).thenApply(results -> results.stream().reduce(Boolean::logicalAnd).orElse(true));
    }

    @Override
    public CompletableFuture<Boolean> retainAll(Collection<? extends String> c) {
        HashMap partitions = Maps.newHashMap();
        c.forEach(key -> partitions.computeIfAbsent(this.getProxyClient().getPartitionId(key), k -> Lists.newArrayList()).add(key));
        return Futures.allOf(partitions.entrySet().stream().map(entry -> this.getProxyClient().applyOn((PartitionId)entry.getKey(), service -> service.retainAll((Collection)entry.getValue())).thenCompose(result -> this.checkLocked((CollectionUpdateResult)result))).collect(Collectors.toList())).thenApply(results -> results.stream().reduce(Boolean::logicalOr).orElse(false));
    }

    @Override
    public CompletableFuture<Boolean> removeAll(Collection<? extends String> c) {
        HashMap partitions = Maps.newHashMap();
        c.forEach(key -> partitions.computeIfAbsent(this.getProxyClient().getPartitionId(key), k -> Lists.newArrayList()).add(key));
        return Futures.allOf(partitions.entrySet().stream().map(entry -> this.getProxyClient().applyOn((PartitionId)entry.getKey(), service -> service.removeAll((Collection)entry.getValue())).thenCompose(result -> this.checkLocked((CollectionUpdateResult)result))).collect(Collectors.toList())).thenApply(results -> results.stream().reduce(Boolean::logicalOr).orElse(false));
    }

    protected <T> CompletableFuture<T> checkLocked(CollectionUpdateResult<T> result) {
        if (result.status() == CollectionUpdateResult.Status.WRITE_LOCK_CONFLICT) {
            return Futures.exceptionalFuture((Throwable)new PrimitiveException.ConcurrentModification());
        }
        return CompletableFuture.completedFuture(result.result());
    }

    @Override
    public synchronized CompletableFuture<Void> addListener(CollectionEventListener<String> listener, Executor executor) {
        if (this.eventListeners.putIfAbsent(listener, executor) == null) {
            return this.getProxyClient().acceptAll(service -> service.listen()).thenApply(v -> null);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<Void> removeListener(CollectionEventListener<String> listener) {
        this.eventListeners.remove(listener);
        if (this.eventListeners.isEmpty()) {
            return this.getProxyClient().acceptAll(service -> service.unlisten()).thenApply(v -> null);
        }
        return CompletableFuture.completedFuture(null);
    }

    private boolean isListening() {
        return !this.eventListeners.isEmpty();
    }

    @Override
    public AsyncIterator<String> iterator() {
        return new PartitionedProxyIterator(this.getProxyClient(), IterableService::iterate, IterableService::next, IterableService::close);
    }

    @Override
    public CompletableFuture<Void> clear() {
        return this.getProxyClient().acceptBy(this.name(), service -> service.clear());
    }

    public CompletableFuture<A> connect() {
        return ((CompletableFuture)super.connect().thenRun(() -> this.getProxyClient().getPartitions().forEach(partition -> partition.addStateChangeListener(state -> {
            if (state == PrimitiveState.CONNECTED && this.isListening()) {
                partition.accept(service -> service.listen());
            }
        })))).thenApply(v -> this);
    }
}

