/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.session.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atomix.primitive.event.EventType;
import io.atomix.primitive.event.PrimitiveEvent;
import io.atomix.primitive.session.SessionClient;
import io.atomix.protocols.raft.protocol.PublishRequest;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.protocol.ResetRequest;
import io.atomix.protocols.raft.session.impl.MemberSelector;
import io.atomix.protocols.raft.session.impl.RaftSessionSequencer;
import io.atomix.protocols.raft.session.impl.RaftSessionState;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.slf4j.Logger;

final class RaftSessionListener {
    private final Logger log;
    private final RaftClientProtocol protocol;
    private final MemberSelector memberSelector;
    private final RaftSessionState state;
    private final Map<EventType, Set<Consumer<PrimitiveEvent>>> eventListeners = Maps.newHashMap();
    private final RaftSessionSequencer sequencer;
    private final Executor executor;

    public RaftSessionListener(RaftClientProtocol protocol, MemberSelector memberSelector, RaftSessionState state, RaftSessionSequencer sequencer, Executor executor) {
        this.protocol = (RaftClientProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
        this.memberSelector = (MemberSelector)Preconditions.checkNotNull((Object)memberSelector, (Object)"nodeSelector cannot be null");
        this.state = (RaftSessionState)Preconditions.checkNotNull((Object)state, (Object)"state cannot be null");
        this.sequencer = (RaftSessionSequencer)Preconditions.checkNotNull((Object)sequencer, (Object)"sequencer cannot be null");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor cannot be null");
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(SessionClient.class).addValue((Object)state.getSessionId()).add("type", (Object)state.getPrimitiveType()).add("name", (Object)state.getPrimitiveName()).build());
        protocol.registerPublishListener(state.getSessionId(), this::handlePublish, executor);
    }

    public void addEventListener(EventType eventType, Consumer<PrimitiveEvent> listener) {
        this.executor.execute(() -> this.eventListeners.computeIfAbsent(eventType.canonicalize(), e -> Sets.newLinkedHashSet()).add(listener));
    }

    public void removeEventListener(EventType eventType, Consumer<PrimitiveEvent> listener) {
        this.executor.execute(() -> this.eventListeners.computeIfAbsent(eventType.canonicalize(), e -> Sets.newLinkedHashSet()).remove(listener));
    }

    private void handlePublish(PublishRequest request) {
        this.log.trace("Received {}", (Object)request);
        if (request.session() != ((Long)this.state.getSessionId().id()).longValue()) {
            this.log.trace("Inconsistent session ID: {}", (Object)request.session());
            return;
        }
        long eventIndex = this.state.getEventIndex();
        if (request.eventIndex() <= eventIndex) {
            this.log.trace("Duplicate event index {}", (Object)request.eventIndex());
            return;
        }
        if (request.previousIndex() != eventIndex) {
            this.log.trace("Inconsistent event index: {}", (Object)request.previousIndex());
            ResetRequest resetRequest = ((ResetRequest.Builder)ResetRequest.builder().withSession((Long)this.state.getSessionId().id())).withIndex(eventIndex).build();
            this.log.trace("Sending {}", (Object)resetRequest);
            this.protocol.reset(this.memberSelector.members(), resetRequest);
            return;
        }
        this.state.setEventIndex(request.eventIndex());
        this.sequencer.sequenceEvent(request, () -> {
            for (PrimitiveEvent event : request.events()) {
                Set<Consumer<PrimitiveEvent>> listeners = this.eventListeners.get(event.type());
                if (listeners == null) continue;
                for (Consumer<PrimitiveEvent> listener : listeners) {
                    listener.accept(event);
                }
            }
        });
    }

    public CompletableFuture<Void> close() {
        this.protocol.unregisterPublishListener(this.state.getSessionId());
        return CompletableFuture.completedFuture(null);
    }
}

