/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.markdown;

import com.vladsch.flexmark.ext.gitlab.internal.GitLabOptions;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.BlockContent;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.zeppelin.markdown.UMLBlockQuote;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UMLBlockQuoteParser
extends AbstractBlockParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(UMLBlockQuoteParser.class);
    private static final Pattern YUML_BLOCK_START = Pattern.compile("(%%%)\\s+(.*\\n)");
    private static final Pattern YUML_BLOCK_END = Pattern.compile("%%%(\\s*$)");
    private final UMLBlockQuote block = new UMLBlockQuote();
    private BlockContent content = new BlockContent();
    private final GitLabOptions options;
    private boolean hadClose = false;

    UMLBlockQuoteParser(DataHolder options, BasedSequence openMarker, BasedSequence openTrailing) {
        this.options = new GitLabOptions(options);
        this.block.setOpeningMarker(openMarker);
        this.block.setOpeningTrailing(openTrailing);
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockContinue tryContinue(ParserState state) {
        BlockParser parser;
        if (this.hadClose) {
            return BlockContinue.none();
        }
        int index = state.getIndex();
        BasedSequence line = state.getLineWithEOL();
        Matcher matcher = YUML_BLOCK_END.matcher((CharSequence)line.subSequence(index));
        if (!matcher.matches()) {
            return BlockContinue.atIndex((int)index);
        }
        Node lastChild = this.block.getLastChild();
        if (lastChild instanceof UMLBlockQuote && (parser = state.getActiveBlockParser((Block)lastChild)) instanceof UMLBlockQuoteParser && !((UMLBlockQuoteParser)parser).hadClose) {
            return BlockContinue.atIndex((int)index);
        }
        this.hadClose = true;
        this.block.setClosingMarker((BasedSequence)state.getLine().subSequence(index, index + 3));
        this.block.setClosingTrailing((BasedSequence)state.getLineWithEOL().subSequence(matcher.start(1), matcher.end(1)));
        return BlockContinue.atIndex((int)state.getLineEndIndex());
    }

    public void addLine(ParserState state, BasedSequence line) {
        this.content.add(line, state.getIndent());
    }

    public void closeBlock(ParserState state) {
        this.block.setContent(this.content);
        this.block.setCharsFromContent();
        this.content = null;
    }

    public boolean isContainer() {
        return true;
    }

    public boolean canContain(ParserState state, BlockParser blockParser, Block block) {
        return true;
    }

    public void parseInlines(InlineParser inlineParser) {
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private final GitLabOptions options;

        BlockFactory(DataHolder options) {
            super(options);
            this.options = new GitLabOptions(options);
        }

        boolean haveBlockQuoteParser(ParserState state) {
            List parsers = state.getActiveBlockParsers();
            int i = parsers.size();
            while (i-- > 0) {
                if (!(parsers.get(i) instanceof UMLBlockQuoteParser)) continue;
                return true;
            }
            return false;
        }

        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            if (this.options.nestedBlockQuotes || !this.haveBlockQuoteParser(state)) {
                BasedSequence line = state.getLineWithEOL();
                Matcher matcher = YUML_BLOCK_START.matcher((CharSequence)line);
                if (matcher.matches()) {
                    LOGGER.debug("Matcher group count {} ", (Object)matcher.groupCount());
                    return BlockStart.of((BlockParser[])new BlockParser[]{new UMLBlockQuoteParser((DataHolder)state.getProperties(), (BasedSequence)line.subSequence(0, 3), (BasedSequence)line.subSequence(4, line.length()))}).atIndex(state.getLineEndIndex());
                }
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        public Set<Class<? extends CustomBlockParserFactory>> getAfterDependents() {
            return null;
        }

        public Set<Class<? extends CustomBlockParserFactory>> getBeforeDependents() {
            return null;
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        public BlockParserFactory apply(DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

