/*
 * Decompiled with CFR 0.152.
 */
package org.pegdown.ast;

import org.pegdown.ast.TextNode;
import org.pegdown.ast.Visitor;

public class AnchorLinkNode
extends TextNode {
    private final String name;

    public AnchorLinkNode(String text) {
        super(text);
        this.name = this.generateName(text);
    }

    public AnchorLinkNode(String textForName, String text) {
        super(text);
        this.name = this.generateName(textForName);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String getName() {
        return this.name;
    }

    private String generateName(String text) {
        StringBuilder sb = new StringBuilder(text.length());
        for (char c : text.toCharArray()) {
            if (Character.isLetterOrDigit(c)) {
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (sb.length() <= 0 || sb.charAt(sb.length() - 1) == '-') continue;
            sb.append('-');
        }
        return sb.toString();
    }
}

