/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.ticket;

import java.util.Calendar;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketContainer.class);
    private Map<String, Entry> sessions = new ConcurrentHashMap<String, Entry>();
    public static final TicketContainer instance = new TicketContainer();

    public boolean isValid(String principal, String ticket) {
        if ("anonymous".equals(principal) && "anonymous".equals(ticket)) {
            return true;
        }
        Entry entry = this.sessions.get(principal);
        return entry != null && entry.ticket.equals(ticket);
    }

    public synchronized String getTicket(String principal) {
        Entry entry = this.sessions.get(principal);
        String ticket = entry == null ? (principal.equals("anonymous") ? "anonymous" : UUID.randomUUID().toString()) : entry.ticket;
        entry = new Entry(ticket);
        this.sessions.put(principal, entry);
        return ticket;
    }

    public synchronized void removeTicket(String principal) {
        try {
            if (this.sessions.get(principal) != null) {
                this.sessions.remove(principal);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error removing ticket", (Throwable)e);
        }
    }

    private static class Entry {
        public final String ticket;
        public final long lastAccessTime;

        Entry(String ticket) {
            this.ticket = ticket;
            this.lastAccessTime = Calendar.getInstance().getTimeInMillis();
        }
    }
}

