/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.scheduler;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronJob
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(CronJob.class);
    private static final String RESULT_SUCCEEDED = "succeeded";
    private static final String RESULT_FAILED = "failed";
    private static final String RESULT_SKIPPED = "skipped";

    public void execute(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        Note note = (Note)jobDataMap.get((Object)"note");
        if (note.haveRunningOrPendingParagraphs()) {
            LOGGER.warn("execution of the cron job is skipped because there is a running or pending paragraph (note id: {})", (Object)note.getId());
            context.setResult((Object)RESULT_SKIPPED);
            return;
        }
        String cronExecutingUser = (String)note.getConfig().get("cronExecutingUser");
        String cronExecutingRoles = (String)note.getConfig().get("cronExecutingRoles");
        if (null == cronExecutingUser) {
            cronExecutingUser = "anonymous";
        }
        AuthenticationInfo authenticationInfo = new AuthenticationInfo(cronExecutingUser, StringUtils.isEmpty((CharSequence)cronExecutingRoles) ? null : cronExecutingRoles, null);
        try {
            note.runAll(authenticationInfo, true, true, new HashMap<String, Object>());
            context.setResult((Object)RESULT_SUCCEEDED);
        }
        catch (Exception e) {
            context.setResult((Object)RESULT_FAILED);
            LOGGER.warn("Fail to run note: {}", (Object)note.getName(), (Object)e);
        }
    }
}

