/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo.zeppelinhub.rest;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxyClient {
    private static final Logger LOG = LoggerFactory.getLogger(HttpProxyClient.class);
    public static final String ZEPPELIN_TOKEN_HEADER = "X-Zeppelin-Token";
    private CloseableHttpAsyncClient client;
    private URI proxyUri;

    public static HttpProxyClient newInstance(URI proxyUri) {
        return new HttpProxyClient(proxyUri);
    }

    private HttpProxyClient(URI uri) {
        this.proxyUri = uri;
        this.client = this.getAsyncProxyHttpClient(this.proxyUri);
        this.client.start();
    }

    public URI getProxyUri() {
        return this.proxyUri;
    }

    private CloseableHttpAsyncClient getAsyncProxyHttpClient(URI proxyUri) {
        LOG.info("Creating async proxy http client");
        PoolingNHttpClientConnectionManager cm = this.getAsyncConnectionManager();
        HttpHost proxy = new HttpHost(proxyUri.getHost(), proxyUri.getPort());
        HttpAsyncClientBuilder clientBuilder = HttpAsyncClients.custom();
        if (cm != null) {
            clientBuilder = clientBuilder.setConnectionManager((NHttpClientConnectionManager)cm);
        }
        if (proxy != null) {
            clientBuilder = clientBuilder.setProxy(proxy);
        }
        clientBuilder = this.setRedirects(clientBuilder);
        return clientBuilder.build();
    }

    private PoolingNHttpClientConnectionManager getAsyncConnectionManager() {
        DefaultConnectingIOReactor ioReactor = null;
        PoolingNHttpClientConnectionManager cm = null;
        try {
            ioReactor = new DefaultConnectingIOReactor();
            SSLContext sslcontext = SSLContexts.createSystemDefault();
            BrowserCompatHostnameVerifier hostnameVerifier = new BrowserCompatHostnameVerifier();
            Registry sessionStrategyRegistry = RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)new SSLIOSessionStrategy(sslcontext, (X509HostnameVerifier)hostnameVerifier)).build();
            cm = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor, sessionStrategyRegistry);
        }
        catch (IOReactorException e) {
            LOG.error("Couldn't initialize multi-threaded async client ", (Throwable)e);
            return null;
        }
        return cm;
    }

    private HttpAsyncClientBuilder setRedirects(HttpAsyncClientBuilder clientBuilder) {
        clientBuilder.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy(){
            private String[] REDIRECT_METHODS = new String[]{"GET", "POST", "PUT", "DELETE", "HEAD"};

            protected boolean isRedirectable(String method) {
                for (String m : this.REDIRECT_METHODS) {
                    if (!m.equalsIgnoreCase(method)) continue;
                    return true;
                }
                return false;
            }
        });
        return clientBuilder;
    }

    public String sendToZeppelinHub(HttpRequestBase request, boolean withResponse) throws IOException {
        return withResponse ? this.sendAndGetResponse(request) : this.sendWithoutResponseBody(request);
    }

    private String sendWithoutResponseBody(HttpRequestBase request) throws IOException {
        FutureCallback<HttpResponse> callback = this.getCallback(request);
        this.client.execute((HttpUriRequest)request, callback);
        return "";
    }

    private String sendAndGetResponse(HttpRequestBase request) throws IOException {
        String data;
        block15: {
            data = "";
            try {
                HttpResponse response = (HttpResponse)this.client.execute((HttpUriRequest)request, null).get(30L, TimeUnit.SECONDS);
                int code = response.getStatusLine().getStatusCode();
                if (code == 200) {
                    try (InputStream responseContent = response.getEntity().getContent();){
                        data = IOUtils.toString((InputStream)responseContent, (String)"UTF-8");
                        break block15;
                    }
                }
                LOG.error("ZeppelinHub {} {} returned with status {} ", new Object[]{request.getMethod(), request.getURI(), code});
                throw new IOException("Cannot perform " + request.getMethod() + " request to ZeppelinHub");
            }
            catch (InterruptedException | NullPointerException | ExecutionException | TimeoutException e) {
                throw new IOException(e);
            }
        }
        return data;
    }

    private FutureCallback<HttpResponse> getCallback(final HttpRequestBase request) {
        return new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse response) {
                request.releaseConnection();
                LOG.info("Note {} completed with {} status", (Object)request.getMethod(), (Object)response.getStatusLine());
            }

            public void failed(Exception ex) {
                request.releaseConnection();
                LOG.error("Note {} failed with {} message", (Object)request.getMethod(), (Object)ex.getMessage());
            }

            public void cancelled() {
                request.releaseConnection();
                LOG.info("Note {} was canceled", (Object)request.getMethod());
            }
        };
    }

    public void stop() {
        try {
            this.client.close();
        }
        catch (Exception e) {
            LOG.error("Failed to close proxy client ", (Throwable)e);
        }
    }
}

