/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParagraphTextParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParagraphTextParser.class);
    private static final Pattern REPL_PATTERN = Pattern.compile("^(\\s*)%(\\w+(?:\\.\\w+)*)");

    private static int parseLocalProperties(String text, int startPos, Map<String, String> localProperties) throws RuntimeException {
        ++startPos;
        String propKey = null;
        boolean insideQuotes = false;
        boolean parseKey = true;
        boolean finished = false;
        StringBuilder sb = new StringBuilder();
        while (!finished && startPos < text.length()) {
            char ch = text.charAt(startPos);
            block0 : switch (ch) {
                case ')': {
                    if (!insideQuotes) {
                        if (parseKey) {
                            propKey = sb.toString().trim();
                            if (!propKey.isEmpty()) {
                                localProperties.put(propKey, propKey);
                            }
                        } else {
                            localProperties.put(propKey, sb.toString().trim());
                        }
                        finished = true;
                        break;
                    }
                    sb.append(ch);
                    break;
                }
                case '\\': {
                    if (startPos + 1 == text.length()) {
                        throw new RuntimeException("Problems by parsing paragraph. Unfinished escape sequence");
                    }
                    ch = text.charAt(++startPos);
                    switch (ch) {
                        case 'n': {
                            sb.append('\n');
                            break block0;
                        }
                        case 't': {
                            sb.append('\t');
                            break block0;
                        }
                    }
                    sb.append(ch);
                    break;
                }
                case '\"': {
                    insideQuotes = !insideQuotes;
                    break;
                }
                case '=': {
                    if (insideQuotes) {
                        sb.append(ch);
                        break;
                    }
                    if (!parseKey) {
                        throw new RuntimeException("Invalid paragraph properties format");
                    }
                    propKey = sb.toString().trim();
                    sb.delete(0, sb.length());
                    parseKey = false;
                    break;
                }
                case ',': {
                    if (insideQuotes) {
                        sb.append(ch);
                        break;
                    }
                    if (propKey == null || propKey.trim().isEmpty()) {
                        throw new RuntimeException("Problems by parsing paragraph. Local property key is empty");
                    }
                    if (parseKey) {
                        propKey = sb.toString().trim();
                        localProperties.put(propKey, propKey);
                    } else {
                        localProperties.put(propKey, sb.toString().trim());
                    }
                    propKey = null;
                    parseKey = true;
                    sb.delete(0, sb.length());
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++startPos;
        }
        if (!finished) {
            throw new RuntimeException("Problems by parsing paragraph. Not finished interpreter configuration");
        }
        return startPos;
    }

    public static ParseResult parse(String text) {
        HashMap<String, String> localProperties = new HashMap<String, String>();
        String intpText = "";
        String scriptText = null;
        Matcher matcher = REPL_PATTERN.matcher(text);
        if (matcher.find()) {
            String headingSpace = matcher.group(1);
            intpText = matcher.group(2);
            int startPos = headingSpace.length() + intpText.length() + 1;
            if (startPos < text.length() && text.charAt(startPos) == '(') {
                startPos = ParagraphTextParser.parseLocalProperties(text, startPos, localProperties);
            }
            scriptText = text.substring(startPos);
        } else {
            intpText = "";
            scriptText = text;
        }
        return new ParseResult(intpText, ParagraphTextParser.removeLeadingWhiteSpaces(scriptText), localProperties);
    }

    private static String removeLeadingWhiteSpaces(String text) {
        int startPos = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == ' ') continue;
            startPos = i;
            break;
        }
        return text.substring(startPos);
    }

    public static class ParseResult {
        private String intpText;
        private String scriptText;
        private Map<String, String> localProperties;

        public ParseResult(String intpText, String scriptText, Map<String, String> localProperties) {
            this.intpText = intpText;
            this.scriptText = scriptText;
            this.localProperties = localProperties;
        }

        public String getIntpText() {
            return this.intpText;
        }

        public String getScriptText() {
            return this.scriptText;
        }

        public Map<String, String> getLocalProperties() {
            return this.localProperties;
        }
    }
}

