/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteEventListener;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NoteEventAsyncListener
implements NoteEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(NoteEventAsyncListener.class);
    private BlockingQueue<NoteEvent> eventsQueue = new LinkedBlockingQueue<NoteEvent>();
    private Thread eventHandlerThread = new EventHandlingThread();

    public NoteEventAsyncListener(String name) {
        this.eventHandlerThread.setName(name);
        this.eventHandlerThread.start();
    }

    public abstract void handleNoteCreateEvent(NoteCreateEvent var1) throws Exception;

    public abstract void handleNoteRemoveEvent(NoteRemoveEvent var1) throws Exception;

    public abstract void handleNoteUpdateEvent(NoteUpdateEvent var1) throws Exception;

    public abstract void handleParagraphCreateEvent(ParagraphCreateEvent var1) throws Exception;

    public abstract void handleParagraphRemoveEvent(ParagraphRemoveEvent var1) throws Exception;

    public abstract void handleParagraphUpdateEvent(ParagraphUpdateEvent var1) throws Exception;

    public void close() {
        this.eventHandlerThread.interrupt();
    }

    @Override
    public void onNoteCreate(Note note, AuthenticationInfo subject) {
        this.eventsQueue.add(new NoteCreateEvent(note, subject));
    }

    @Override
    public void onNoteRemove(Note note, AuthenticationInfo subject) {
        this.eventsQueue.add(new NoteRemoveEvent(note, subject));
    }

    @Override
    public void onNoteUpdate(Note note, AuthenticationInfo subject) {
        this.eventsQueue.add(new NoteUpdateEvent(note, subject));
    }

    @Override
    public void onParagraphCreate(Paragraph p) {
        this.eventsQueue.add(new ParagraphCreateEvent(p));
    }

    @Override
    public void onParagraphRemove(Paragraph p) {
        this.eventsQueue.add(new ParagraphRemoveEvent(p));
    }

    @Override
    public void onParagraphUpdate(Paragraph p) {
        this.eventsQueue.add(new ParagraphUpdateEvent(p));
    }

    @Override
    public void onParagraphStatusChange(Paragraph p, Job.Status status) {
        this.eventsQueue.add(new ParagraphStatusChangeEvent(p));
    }

    public void drainEvents() throws InterruptedException {
        while (!this.eventsQueue.isEmpty()) {
            Thread.sleep(1000L);
        }
        Thread.sleep(5000L);
    }

    public static class ParagraphStatusChangeEvent
    implements NoteEvent {
        private Paragraph p;

        public ParagraphStatusChangeEvent(Paragraph p) {
            this.p = p;
        }

        public Paragraph getParagraph() {
            return this.p;
        }
    }

    public static class ParagraphRemoveEvent
    implements NoteEvent {
        private Paragraph p;

        public ParagraphRemoveEvent(Paragraph p) {
            this.p = p;
        }

        public Paragraph getParagraph() {
            return this.p;
        }
    }

    public static class ParagraphUpdateEvent
    implements NoteEvent {
        private Paragraph p;

        public ParagraphUpdateEvent(Paragraph p) {
            this.p = p;
        }

        public Paragraph getParagraph() {
            return this.p;
        }
    }

    public static class ParagraphCreateEvent
    implements NoteEvent {
        private Paragraph p;

        public ParagraphCreateEvent(Paragraph p) {
            this.p = p;
        }

        public Paragraph getParagraph() {
            return this.p;
        }
    }

    public static class NoteRemoveEvent
    implements NoteEvent {
        private Note note;
        private AuthenticationInfo subject;

        public NoteRemoveEvent(Note note, AuthenticationInfo subject) {
            this.note = note;
            this.subject = subject;
        }

        public Note getNote() {
            return this.note;
        }
    }

    public static class NoteUpdateEvent
    implements NoteEvent {
        private Note note;
        private AuthenticationInfo subject;

        public NoteUpdateEvent(Note note, AuthenticationInfo subject) {
            this.note = note;
            this.subject = subject;
        }

        public Note getNote() {
            return this.note;
        }
    }

    public static class NoteCreateEvent
    implements NoteEvent {
        private Note note;
        private AuthenticationInfo subject;

        public NoteCreateEvent(Note note, AuthenticationInfo subject) {
            this.note = note;
            this.subject = subject;
        }

        public Note getNote() {
            return this.note;
        }
    }

    static interface NoteEvent {
    }

    class EventHandlingThread
    extends Thread {
        EventHandlingThread() {
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    NoteEvent event = (NoteEvent)NoteEventAsyncListener.this.eventsQueue.take();
                    if (event instanceof NoteCreateEvent) {
                        NoteEventAsyncListener.this.handleNoteCreateEvent((NoteCreateEvent)event);
                        continue;
                    }
                    if (event instanceof NoteRemoveEvent) {
                        NoteEventAsyncListener.this.handleNoteRemoveEvent((NoteRemoveEvent)event);
                        continue;
                    }
                    if (event instanceof NoteUpdateEvent) {
                        NoteEventAsyncListener.this.handleNoteUpdateEvent((NoteUpdateEvent)event);
                        continue;
                    }
                    if (event instanceof ParagraphCreateEvent) {
                        NoteEventAsyncListener.this.handleParagraphCreateEvent((ParagraphCreateEvent)event);
                        continue;
                    }
                    if (event instanceof ParagraphRemoveEvent) {
                        NoteEventAsyncListener.this.handleParagraphRemoveEvent((ParagraphRemoveEvent)event);
                        continue;
                    }
                    if (event instanceof ParagraphUpdateEvent) {
                        NoteEventAsyncListener.this.handleParagraphUpdateEvent((ParagraphUpdateEvent)event);
                        continue;
                    }
                    throw new RuntimeException("Unknown event: " + event.getClass().getSimpleName());
                }
                catch (Exception e) {
                    LOGGER.error("Fail to handle NoteEvent", (Throwable)e);
                }
            }
        }
    }
}

