/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.recovery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.interpreter.launcher.InterpreterClient;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterRunningProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecoveryUtils.class);

    public static String getRecoveryData(InterpreterSetting interpreterSetting) {
        ArrayList<String> recoveryData = new ArrayList<String>();
        if (interpreterSetting != null) {
            for (ManagedInterpreterGroup interpreterGroup : interpreterSetting.getAllInterpreterGroups()) {
                RemoteInterpreterProcess interpreterProcess = interpreterGroup.getInterpreterProcess();
                if (interpreterProcess == null || !interpreterProcess.isRunning()) continue;
                recoveryData.add(interpreterGroup.getId() + "\t" + interpreterProcess.getHost() + ":" + interpreterProcess.getPort());
            }
        }
        return StringUtils.join(recoveryData, (String)System.lineSeparator());
    }

    public static Map<String, InterpreterClient> restoreFromRecoveryData(String recoveryData, String interpreterSettingName, InterpreterSettingManager interpreterSettingManager, ZeppelinConfiguration zConf) {
        int connectTimeout = zConf.getInt(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_CONNECT_TIMEOUT);
        Properties interpreterProperties = interpreterSettingManager.getByName(interpreterSettingName).getJavaProperties();
        int connectionPoolSize = Integer.parseInt(interpreterProperties.getProperty(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_CONNECTION_POOL_SIZE.getVarName(), ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_CONNECTION_POOL_SIZE.getIntValue() + ""));
        HashMap<String, InterpreterClient> clients = new HashMap<String, InterpreterClient>();
        if (!StringUtils.isBlank((CharSequence)recoveryData)) {
            for (String line : recoveryData.split(System.lineSeparator())) {
                String[] tokens = line.split("\t");
                String interpreterGroupId = tokens[0];
                String[] hostPort = tokens[1].split(":");
                RemoteInterpreterRunningProcess client = new RemoteInterpreterRunningProcess(interpreterSettingName, interpreterGroupId, connectTimeout, connectionPoolSize, interpreterSettingManager.getInterpreterEventServer().getHost(), interpreterSettingManager.getInterpreterEventServer().getPort(), hostPort[0], Integer.parseInt(hostPort[1]), true);
                clients.put(interpreterGroupId, client);
                LOGGER.info("Recovering Interpreter Process: " + interpreterGroupId + ", " + hostPort[0] + ":" + hostPort[1]);
            }
        }
        return clients;
    }
}

