/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.zeppelin.common.JsonSerializable;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.RemoteRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpreterInfoSaving
implements JsonSerializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterpreterInfoSaving.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Authentication.class, new InterfaceAdapter()).create();
    public Map<String, InterpreterSetting> interpreterSettings = new HashMap<String, InterpreterSetting>();
    public List<RemoteRepository> interpreterRepositories = new ArrayList<RemoteRepository>();

    public static InterpreterInfoSaving loadFromFile(Path file) throws IOException {
        LOGGER.info("Load interpreter setting from file: {}", (Object)file);
        InterpreterInfoSaving infoSaving = null;
        try (BufferedReader json = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            JsonObject jsonObject = JsonParser.parseReader((Reader)json).getAsJsonObject();
            infoSaving = InterpreterInfoSaving.fromJson(jsonObject.toString());
            if (infoSaving != null && infoSaving.interpreterSettings != null) {
                for (InterpreterSetting interpreterSetting : infoSaving.interpreterSettings.values()) {
                    interpreterSetting.convertPermissionsFromUsersToOwners(jsonObject.getAsJsonObject("interpreterSettings").getAsJsonObject(interpreterSetting.getId()));
                }
            }
        }
        return infoSaving == null ? new InterpreterInfoSaving() : infoSaving;
    }

    public void saveToFile(Path file) throws IOException {
        if (!Files.exists(file, new LinkOption[0])) {
            Files.createFile(file, new FileAttribute[0]);
            try {
                EnumSet<PosixFilePermission> permissions = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE);
                Files.setPosixFilePermissions(file, permissions);
            }
            catch (UnsupportedOperationException e) {
                LOGGER.warn("unable to setPosixFilePermissions on '{}'.", (Object)file);
            }
        }
        LOGGER.info("Save Interpreter Settings to {}", (Object)file);
        IOUtils.write((String)this.toJson(), (OutputStream)new FileOutputStream(file.toFile()), (Charset)StandardCharsets.UTF_8);
    }

    public String toJson() {
        return GSON.toJson((Object)this);
    }

    public static InterpreterInfoSaving fromJson(String json) {
        return (InterpreterInfoSaving)GSON.fromJson(json, InterpreterInfoSaving.class);
    }

    static class InterfaceAdapter<T>
    implements JsonSerializer<T>,
    JsonDeserializer<T> {
        InterfaceAdapter() {
        }

        public JsonElement serialize(T object, Type interfaceType, JsonSerializationContext context) {
            JsonObject wrapper = new JsonObject();
            wrapper.addProperty("type", object.getClass().getName());
            wrapper.add("data", context.serialize(object));
            return wrapper;
        }

        public T deserialize(JsonElement elem, Type interfaceType, JsonDeserializationContext context) throws JsonParseException {
            JsonObject wrapper = (JsonObject)elem;
            JsonElement typeName = this.get(wrapper, "type");
            JsonElement data = this.get(wrapper, "data");
            Type actualType = this.typeForName(typeName);
            return (T)context.deserialize(data, actualType);
        }

        private Type typeForName(JsonElement typeElem) {
            try {
                return Class.forName(typeElem.getAsString());
            }
            catch (ClassNotFoundException e) {
                throw new JsonParseException((Throwable)e);
            }
        }

        private JsonElement get(JsonObject wrapper, String memberName) {
            JsonElement elem = wrapper.get(memberName);
            if (elem == null) {
                throw new JsonParseException("no '" + memberName + "' member found in what was expected to be an interface wrapper");
            }
            return elem;
        }
    }
}

