/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.helium;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import org.apache.zeppelin.helium.ApplicationEventListener;
import org.apache.zeppelin.helium.ApplicationException;
import org.apache.zeppelin.helium.HeliumPackage;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.interpreter.remote.RemoteAngularObjectRegistry;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.thrift.RemoteApplicationResult;
import org.apache.zeppelin.notebook.ApplicationState;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteEventListener;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.scheduler.ExecutorFactory;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeliumApplicationFactory
implements ApplicationEventListener,
NoteEventListener {
    private final Logger logger = LoggerFactory.getLogger(HeliumApplicationFactory.class);
    private final ExecutorService executor = ExecutorFactory.singleton().createOrGet(HeliumApplicationFactory.class.getName(), 10);
    private Notebook notebook;
    private ApplicationEventListener applicationEventListener;

    @Inject
    public HeliumApplicationFactory(Notebook notebook, ApplicationEventListener applicationEventListener) {
        this.notebook = notebook;
        this.applicationEventListener = applicationEventListener;
        this.notebook.addNotebookEventListener(this);
    }

    private boolean isRemote(InterpreterGroup group) {
        return group.getAngularObjectRegistry() instanceof RemoteAngularObjectRegistry;
    }

    public String loadAndRun(HeliumPackage pkg, Paragraph paragraph) {
        ApplicationState appState = paragraph.createOrGetApplicationState(pkg);
        this.onLoad(paragraph.getNote().getId(), paragraph.getId(), appState.getId(), appState.getHeliumPackage());
        this.executor.submit(new LoadApplication(appState, pkg, paragraph));
        return appState.getId();
    }

    public ApplicationState get(Paragraph paragraph, String appId) {
        return paragraph.getApplicationState(appId);
    }

    public void unload(Paragraph paragraph, String appId) {
        this.executor.execute(new UnloadApplication(paragraph, appId));
    }

    public void run(Paragraph paragraph, String appId) {
        this.executor.execute(new RunApplication(paragraph, appId));
    }

    public void onOutputAppend(String noteId, String paragraphId, int index, String appId, String output) {
        ApplicationState appToUpdate = this.getAppState(noteId, paragraphId, appId);
        if (appToUpdate != null) {
            appToUpdate.appendOutput(output);
        } else {
            this.logger.error("Can't find app {}", (Object)appId);
        }
        if (this.applicationEventListener != null) {
            this.applicationEventListener.onOutputAppend(noteId, paragraphId, index, appId, output);
        }
    }

    public void onOutputUpdated(String noteId, String paragraphId, int index, String appId, InterpreterResult.Type type, String output) {
        ApplicationState appToUpdate = this.getAppState(noteId, paragraphId, appId);
        if (appToUpdate != null) {
            appToUpdate.setOutput(output);
        } else {
            this.logger.error("Can't find app {}", (Object)appId);
        }
        if (this.applicationEventListener != null) {
            this.applicationEventListener.onOutputUpdated(noteId, paragraphId, index, appId, type, output);
        }
    }

    public void onLoad(String noteId, String paragraphId, String appId, HeliumPackage pkg) {
        if (this.applicationEventListener != null) {
            this.applicationEventListener.onLoad(noteId, paragraphId, appId, pkg);
        }
    }

    public void onStatusChange(String noteId, String paragraphId, String appId, String status) {
        ApplicationState appToUpdate = this.getAppState(noteId, paragraphId, appId);
        if (appToUpdate != null) {
            appToUpdate.setStatus(ApplicationState.Status.valueOf(status));
        }
        if (this.applicationEventListener != null) {
            this.applicationEventListener.onStatusChange(noteId, paragraphId, appId, status);
        }
    }

    private void appStatusChange(Paragraph paragraph, String appId, ApplicationState.Status status) {
        ApplicationState app = paragraph.getApplicationState(appId);
        app.setStatus(status);
        this.onStatusChange(paragraph.getNote().getId(), paragraph.getId(), appId, status.toString());
    }

    private ApplicationState getAppState(String noteId, String paragraphId, String appId) {
        if (this.notebook == null) {
            return null;
        }
        Note note = null;
        try {
            note = this.notebook.getNote(noteId);
            if (note == null) {
                this.logger.warn("Note " + noteId + " not found");
                return null;
            }
        }
        catch (IOException e) {
            this.logger.error("Can't get note {}", (Object)noteId);
            return null;
        }
        Paragraph paragraph = note.getParagraph(paragraphId);
        if (paragraph == null) {
            this.logger.error("Can't get paragraph {}", (Object)paragraphId);
            return null;
        }
        ApplicationState appFound = paragraph.getApplicationState(appId);
        return appFound;
    }

    @Override
    public void onNoteRemove(Note note, AuthenticationInfo subject) throws IOException {
    }

    @Override
    public void onNoteCreate(Note note, AuthenticationInfo subject) throws IOException {
    }

    @Override
    public void onNoteUpdate(Note note, AuthenticationInfo subject) throws IOException {
    }

    @Override
    public void onParagraphRemove(Paragraph paragraph) {
        List<ApplicationState> appStates = paragraph.getAllApplicationStates();
        for (ApplicationState app : appStates) {
            UnloadApplication unloadJob = new UnloadApplication(paragraph, app.getId());
            unloadJob.run();
        }
    }

    @Override
    public void onParagraphCreate(Paragraph p) {
    }

    @Override
    public void onParagraphUpdate(Paragraph p) throws IOException {
    }

    @Override
    public void onParagraphStatusChange(Paragraph p, Job.Status status) {
        if (status == Job.Status.FINISHED) {
            List<ApplicationState> appStates = p.getAllApplicationStates();
            for (ApplicationState app : appStates) {
                this.loadAndRun(app.getHeliumPackage(), p);
            }
        }
    }

    private class RunApplication
    implements Runnable {
        private final Paragraph paragraph;
        private final String appId;

        public RunApplication(Paragraph paragraph, String appId) {
            this.paragraph = paragraph;
            this.appId = appId;
        }

        @Override
        public void run() {
            block3: {
                ApplicationState appState = null;
                try {
                    appState = this.paragraph.getApplicationState(this.appId);
                    if (appState == null) {
                        HeliumApplicationFactory.this.logger.warn("Can not find {} to unload from {}", (Object)this.appId, (Object)this.paragraph.getId());
                        return;
                    }
                    this.run(appState);
                }
                catch (Exception e) {
                    HeliumApplicationFactory.this.logger.error(e.getMessage(), (Throwable)e);
                    if (appState == null) break block3;
                    HeliumApplicationFactory.this.appStatusChange(this.paragraph, this.appId, ApplicationState.Status.UNLOADED);
                    appState.setOutput(e.getMessage());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void run(ApplicationState app) throws ApplicationException {
            ApplicationState applicationState = app;
            synchronized (applicationState) {
                if (app.getStatus() != ApplicationState.Status.LOADED) {
                    throw new ApplicationException("Can't run application status " + (Object)((Object)app.getStatus()));
                }
                Interpreter intp = null;
                try {
                    intp = this.paragraph.getBindedInterpreter();
                }
                catch (InterpreterException e) {
                    throw new ApplicationException("No interpreter found", (Throwable)e);
                }
                RemoteInterpreterProcess intpProcess = ((ManagedInterpreterGroup)intp.getInterpreterGroup()).getRemoteInterpreterProcess();
                if (intpProcess == null) {
                    throw new ApplicationException("Target interpreter process is not running");
                }
                RemoteApplicationResult ret = (RemoteApplicationResult)intpProcess.callRemoteFunction(client -> client.runApplication(app.getId()));
                if (!ret.isSuccess()) {
                    throw new ApplicationException(ret.getMsg());
                }
            }
        }
    }

    private class UnloadApplication
    implements Runnable {
        private final Paragraph paragraph;
        private final String appId;

        public UnloadApplication(Paragraph paragraph, String appId) {
            this.paragraph = paragraph;
            this.appId = appId;
        }

        @Override
        public void run() {
            block4: {
                ApplicationState appState = null;
                try {
                    appState = this.paragraph.getApplicationState(this.appId);
                    if (appState == null) {
                        HeliumApplicationFactory.this.logger.warn("Can not find {} to unload from {}", (Object)this.appId, (Object)this.paragraph.getId());
                        return;
                    }
                    if (appState.getStatus() == ApplicationState.Status.UNLOADED) {
                        return;
                    }
                    this.unload(appState);
                }
                catch (Exception e) {
                    HeliumApplicationFactory.this.logger.error(e.getMessage(), (Throwable)e);
                    if (appState == null) break block4;
                    HeliumApplicationFactory.this.appStatusChange(this.paragraph, this.appId, ApplicationState.Status.ERROR);
                    appState.setOutput(e.getMessage());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unload(ApplicationState appsToUnload) throws ApplicationException {
            ApplicationState applicationState = appsToUnload;
            synchronized (applicationState) {
                if (appsToUnload.getStatus() != ApplicationState.Status.LOADED) {
                    throw new ApplicationException("Can't unload application status " + (Object)((Object)appsToUnload.getStatus()));
                }
                HeliumApplicationFactory.this.appStatusChange(this.paragraph, appsToUnload.getId(), ApplicationState.Status.UNLOADING);
                Interpreter intp = null;
                try {
                    intp = this.paragraph.getBindedInterpreter();
                }
                catch (InterpreterException e) {
                    throw new ApplicationException("No interpreter found", (Throwable)e);
                }
                RemoteInterpreterProcess intpProcess = ((ManagedInterpreterGroup)intp.getInterpreterGroup()).getRemoteInterpreterProcess();
                if (intpProcess == null) {
                    throw new ApplicationException("Target interpreter process is not running");
                }
                RemoteApplicationResult ret = (RemoteApplicationResult)intpProcess.callRemoteFunction(client -> client.unloadApplication(appsToUnload.getId()));
                if (!ret.isSuccess()) {
                    throw new ApplicationException(ret.getMsg());
                }
                HeliumApplicationFactory.this.appStatusChange(this.paragraph, appsToUnload.getId(), ApplicationState.Status.UNLOADED);
            }
        }
    }

    private class LoadApplication
    implements Runnable {
        private final HeliumPackage pkg;
        private final Paragraph paragraph;
        private final ApplicationState appState;

        public LoadApplication(ApplicationState appState, HeliumPackage pkg, Paragraph paragraph) {
            this.appState = appState;
            this.pkg = pkg;
            this.paragraph = paragraph;
        }

        @Override
        public void run() {
            block3: {
                try {
                    Interpreter intp = this.paragraph.getBindedInterpreter();
                    ManagedInterpreterGroup intpGroup = (ManagedInterpreterGroup)intp.getInterpreterGroup();
                    RemoteInterpreterProcess intpProcess = intpGroup.getRemoteInterpreterProcess();
                    if (intpProcess == null) {
                        throw new ApplicationException("Target interpreter process is not running");
                    }
                    this.load(intpProcess, this.appState);
                    RunApplication runTask = new RunApplication(this.paragraph, this.appState.getId());
                    runTask.run();
                }
                catch (Exception e) {
                    HeliumApplicationFactory.this.logger.error(e.getMessage(), (Throwable)e);
                    if (this.appState == null) break block3;
                    HeliumApplicationFactory.this.appStatusChange(this.paragraph, this.appState.getId(), ApplicationState.Status.ERROR);
                    this.appState.setOutput(e.getMessage());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void load(RemoteInterpreterProcess intpProcess, ApplicationState appState) throws Exception {
            ApplicationState applicationState = appState;
            synchronized (applicationState) {
                if (appState.getStatus() == ApplicationState.Status.LOADED) {
                    return;
                }
                HeliumApplicationFactory.this.appStatusChange(this.paragraph, appState.getId(), ApplicationState.Status.LOADING);
                String pkgInfo = this.pkg.toJson();
                String appId = appState.getId();
                RemoteApplicationResult ret = (RemoteApplicationResult)intpProcess.callRemoteFunction(client -> client.loadApplication(appId, pkgInfo, this.paragraph.getNote().getId(), this.paragraph.getId()));
                if (!ret.isSuccess()) {
                    throw new ApplicationException(ret.getMsg());
                }
                HeliumApplicationFactory.this.appStatusChange(this.paragraph, appState.getId(), ApplicationState.Status.LOADED);
            }
        }
    }
}

