/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.lang.reflect.Method;
import org.slf4j.helpers.Util;

public class VersionUtil {
    static final int MINIMAL_VERSION = 5;

    public static int getJavaMajorVersion() {
        String javaVersionString = Util.safeGetSystemProperty("java.version");
        return VersionUtil.getJavaMajorVersion(javaVersionString);
    }

    static int getJavaMajorVersion(String versionString2) {
        if (versionString2 == null) {
            return 5;
        }
        if (versionString2.startsWith("1.")) {
            return versionString2.charAt(2) - 48;
        }
        try {
            Method versionMethod = Runtime.class.getMethod("version", new Class[0]);
            Object versionObj = versionMethod.invoke(null, new Object[0]);
            Method majorMethod = versionObj.getClass().getMethod("major", new Class[0]);
            Integer resultInteger = (Integer)majorMethod.invoke(versionObj, new Object[0]);
            return resultInteger;
        }
        catch (Exception e) {
            return 5;
        }
    }
}

