/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm.commons;

import java.util.List;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Attribute;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.ModuleVisitor;
import org.jetbrains.org.objectweb.asm.TypePath;
import org.jetbrains.org.objectweb.asm.commons.AnnotationRemapper;
import org.jetbrains.org.objectweb.asm.commons.FieldRemapper;
import org.jetbrains.org.objectweb.asm.commons.MethodRemapper;
import org.jetbrains.org.objectweb.asm.commons.ModuleHashesAttribute;
import org.jetbrains.org.objectweb.asm.commons.ModuleRemapper;
import org.jetbrains.org.objectweb.asm.commons.Remapper;

public class ClassRemapper
extends ClassVisitor {
    protected final Remapper remapper;
    protected String className;

    public ClassRemapper(ClassVisitor classVisitor2, Remapper remapper2) {
        this(458752, classVisitor2, remapper2);
    }

    protected ClassRemapper(int api, ClassVisitor classVisitor2, Remapper remapper2) {
        super(api, classVisitor2);
        this.remapper = remapper2;
    }

    public void visit(int version, int access, String name2, String signature2, String superName, String[] interfaces) {
        this.className = name2;
        super.visit(version, access, this.remapper.mapType(name2), this.remapper.mapSignature(signature2, false), this.remapper.mapType(superName), interfaces == null ? null : this.remapper.mapTypes(interfaces));
    }

    public ModuleVisitor visitModule(String name2, int flags, String version) {
        ModuleVisitor moduleVisitor = super.visitModule(this.remapper.mapModuleName(name2), flags, version);
        return moduleVisitor == null ? null : this.createModuleRemapper(moduleVisitor);
    }

    public AnnotationVisitor visitAnnotation(String descriptor2, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitAnnotation(this.remapper.mapDesc(descriptor2), visible);
        return annotationVisitor == null ? null : this.createAnnotationRemapper(annotationVisitor);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitTypeAnnotation(typeRef, typePath, this.remapper.mapDesc(descriptor2), visible);
        return annotationVisitor == null ? null : this.createAnnotationRemapper(annotationVisitor);
    }

    public void visitAttribute(Attribute attribute) {
        if (attribute instanceof ModuleHashesAttribute) {
            ModuleHashesAttribute moduleHashesAttribute = (ModuleHashesAttribute)attribute;
            List<String> modules = moduleHashesAttribute.modules;
            for (int i = 0; i < modules.size(); ++i) {
                modules.set(i, this.remapper.mapModuleName(modules.get(i)));
            }
        }
        super.visitAttribute(attribute);
    }

    public FieldVisitor visitField(int access, String name2, String descriptor2, String signature2, Object value) {
        FieldVisitor fieldVisitor = super.visitField(access, this.remapper.mapFieldName(this.className, name2, descriptor2), this.remapper.mapDesc(descriptor2), this.remapper.mapSignature(signature2, true), value == null ? null : this.remapper.mapValue(value));
        return fieldVisitor == null ? null : this.createFieldRemapper(fieldVisitor);
    }

    public MethodVisitor visitMethod(int access, String name2, String descriptor2, String signature2, String[] exceptions) {
        String remappedDescriptor = this.remapper.mapMethodDesc(descriptor2);
        MethodVisitor methodVisitor = super.visitMethod(access, this.remapper.mapMethodName(this.className, name2, descriptor2), remappedDescriptor, this.remapper.mapSignature(signature2, false), exceptions == null ? null : this.remapper.mapTypes(exceptions));
        return methodVisitor == null ? null : this.createMethodRemapper(methodVisitor);
    }

    public void visitInnerClass(String name2, String outerName, String innerName, int access) {
        super.visitInnerClass(this.remapper.mapType(name2), outerName == null ? null : this.remapper.mapType(outerName), innerName == null ? null : this.remapper.mapInnerClassName(name2, outerName, innerName), access);
    }

    public void visitOuterClass(String owner, String name2, String descriptor2) {
        super.visitOuterClass(this.remapper.mapType(owner), name2 == null ? null : this.remapper.mapMethodName(owner, name2, descriptor2), descriptor2 == null ? null : this.remapper.mapMethodDesc(descriptor2));
    }

    public void visitNestHost(String nestHost) {
        super.visitNestHost(this.remapper.mapType(nestHost));
    }

    public void visitNestMember(String nestMember) {
        super.visitNestMember(this.remapper.mapType(nestMember));
    }

    protected FieldVisitor createFieldRemapper(FieldVisitor fieldVisitor) {
        return new FieldRemapper(this.api, fieldVisitor, this.remapper);
    }

    protected MethodVisitor createMethodRemapper(MethodVisitor methodVisitor) {
        return new MethodRemapper(this.api, methodVisitor, this.remapper);
    }

    protected AnnotationVisitor createAnnotationRemapper(AnnotationVisitor annotationVisitor) {
        return new AnnotationRemapper(this.api, annotationVisitor, this.remapper);
    }

    protected ModuleVisitor createModuleRemapper(ModuleVisitor moduleVisitor) {
        return new ModuleRemapper(this.api, moduleVisitor, this.remapper);
    }
}

