/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.repl.reader;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.repl.ReplUtilKt;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.reader.ReplSystemInWrapperKt;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.writer.ReplWriter;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\tH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/reader/ReplSystemInWrapper;", "Ljava/io/InputStream;", "stdin", "replWriter", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/writer/ReplWriter;", "(Ljava/io/InputStream;Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/writer/ReplWriter;)V", "byteBuilder", "Ljava/io/ByteArrayOutputStream;", "curBytePos", "", "inputByteArray", "", "isAtBufferEnd", "", "()Z", "isLastByteProcessed", "isReadLineStartSent", "isReplScriptExecuting", "setReplScriptExecuting", "(Z)V", "isXmlIncomplete", "parseInput", "", "read", "resetBufferIfNeeded", "", "kotlin-scripting-compiler"})
public final class ReplSystemInWrapper
extends InputStream {
    private boolean isXmlIncomplete;
    private boolean isLastByteProcessed;
    private boolean isReadLineStartSent;
    private ByteArrayOutputStream byteBuilder;
    private int curBytePos;
    private byte[] inputByteArray;
    private volatile boolean isReplScriptExecuting;
    private final InputStream stdin;
    private final ReplWriter replWriter;

    private final boolean isAtBufferEnd() {
        return this.curBytePos == this.inputByteArray.length;
    }

    public final boolean isReplScriptExecuting() {
        return this.isReplScriptExecuting;
    }

    public final void setReplScriptExecuting(boolean bl) {
        this.isReplScriptExecuting = bl;
    }

    @Override
    public int read() {
        if (this.isLastByteProcessed) {
            if (this.isReplScriptExecuting) {
                this.isReadLineStartSent = false;
                this.replWriter.notifyReadLineEnd();
            }
            this.isLastByteProcessed = false;
            return -1;
        }
        while (this.isXmlIncomplete) {
            byte[] byArray;
            if (!this.isReadLineStartSent && this.isReplScriptExecuting) {
                this.replWriter.notifyReadLineStart();
                this.isReadLineStartSent = true;
            }
            this.byteBuilder.write(this.stdin.read());
            String string = this.byteBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull(string, "byteBuilder.toString()");
            if (!StringsKt.endsWith$default((CharSequence)string, '\n', false, 2, null)) continue;
            this.isXmlIncomplete = false;
            this.isLastByteProcessed = false;
            String string2 = this.parseInput();
            ReplSystemInWrapper replSystemInWrapper = this;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull(string3.getBytes(charset), "(this as java.lang.String).getBytes(charset)");
            replSystemInWrapper.inputByteArray = byArray;
        }
        int n = this.curBytePos;
        this.curBytePos = n + 1;
        byte nextByte = this.inputByteArray[n];
        this.resetBufferIfNeeded();
        return nextByte;
    }

    private final String parseInput() {
        String string = this.byteBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "byteBuilder.toString()");
        String xmlInput = string;
        String unescapedXml = ReplSystemInWrapperKt.access$parseXml(xmlInput);
        return this.isReplScriptExecuting ? ReplUtilKt.replUnescapeLineBreaks(unescapedXml) : unescapedXml;
    }

    private final void resetBufferIfNeeded() {
        if (this.isAtBufferEnd()) {
            this.isXmlIncomplete = true;
            this.byteBuilder = new ByteArrayOutputStream();
            this.curBytePos = 0;
            this.isLastByteProcessed = true;
        }
    }

    public ReplSystemInWrapper(@NotNull InputStream stdin, @NotNull ReplWriter replWriter) {
        Intrinsics.checkParameterIsNotNull(stdin, "stdin");
        Intrinsics.checkParameterIsNotNull(replWriter, "replWriter");
        this.stdin = stdin;
        this.replWriter = replWriter;
        this.isXmlIncomplete = true;
        this.byteBuilder = new ByteArrayOutputStream();
        this.inputByteArray = new byte[0];
    }
}

