/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Map;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public class ReifiedTypeParameterSubstitutionChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        if (resolvedCall2 == null) {
            ReifiedTypeParameterSubstitutionChecker.$$$reportNull$$$0(0);
        }
        if (reportOn == null) {
            ReifiedTypeParameterSubstitutionChecker.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            ReifiedTypeParameterSubstitutionChecker.$$$reportNull$$$0(2);
        }
        Map<TypeParameterDescriptor, KotlinType> typeArguments2 = resolvedCall2.getTypeArguments();
        for (Map.Entry<TypeParameterDescriptor, KotlinType> entry : typeArguments2.entrySet()) {
            PsiElement reportErrorOn;
            TypeParameterDescriptor parameter = entry.getKey();
            KotlinType argument = entry.getValue();
            ClassifierDescriptor argumentDeclarationDescriptor = argument.getConstructor().getDeclarationDescriptor();
            if (!parameter.isReified() && !ReifiedTypeParameterSubstitutionChecker.isTypeParameterOfKotlinArray(parameter)) continue;
            KtTypeProjection typeProjection = CollectionsKt.getOrNull(resolvedCall2.getCall().getTypeArguments(), parameter.getIndex());
            PsiElement psiElement = reportErrorOn = typeProjection != null ? typeProjection : reportOn;
            if (argumentDeclarationDescriptor instanceof TypeParameterDescriptor && !((TypeParameterDescriptor)argumentDeclarationDescriptor).isReified()) {
                context2.getTrace().report(Errors.TYPE_PARAMETER_AS_REIFIED.on(reportErrorOn, (TypeParameterDescriptor)argumentDeclarationDescriptor));
                continue;
            }
            if (!TypeUtilsKt.cannotBeReified(argument)) continue;
            context2.getTrace().report(Errors.REIFIED_TYPE_FORBIDDEN_SUBSTITUTION.on(reportErrorOn, argument));
        }
    }

    private static boolean isTypeParameterOfKotlinArray(@NotNull TypeParameterDescriptor parameter) {
        DeclarationDescriptor container2;
        if (parameter == null) {
            ReifiedTypeParameterSubstitutionChecker.$$$reportNull$$$0(3);
        }
        return (container2 = parameter.getContainingDeclaration()) instanceof ClassDescriptor && KotlinBuiltIns.isNonPrimitiveArray((ClassDescriptor)container2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCall";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportOn";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/checkers/ReifiedTypeParameterSubstitutionChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "check";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isTypeParameterOfKotlinArray";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

