/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.OperatorCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.ErrorUtils;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/OperatorCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "Companion", "frontend"})
public final class OperatorCallChecker
implements CallChecker {
    public static final Companion Companion = new Companion(null);

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        boolean isConventionOperator;
        KtElement ktElement;
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Object obj = resolvedCall2.getResultingDescriptor();
        if (!(obj instanceof FunctionDescriptor)) {
            obj = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)obj;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        if (!OperatorCallChecker.Companion.checkNotErrorOrDynamic(functionDescriptor2)) {
            return;
        }
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull(call2, "resolvedCall.call");
        KtExpression ktExpression = call2.getCalleeExpression();
        if (ktExpression != null) {
            ktElement = ktExpression;
        } else {
            Call call3 = resolvedCall2.getCall();
            Intrinsics.checkExpressionValueIsNotNull(call3, "resolvedCall.call");
            ktElement = call3.getCallElement();
        }
        Intrinsics.checkExpressionValueIsNotNull(ktElement, "resolvedCall.call.callee\u2026lvedCall.call.callElement");
        KtElement element = ktElement;
        Call call4 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull(call4, "resolvedCall.call");
        Call call5 = call4;
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall && call5 instanceof CallTransformer.CallForImplicitInvoke && ((CallTransformer.CallForImplicitInvoke)call5).itIsVariableAsFunctionCall) {
            Call call6 = ((CallTransformer.CallForImplicitInvoke)call5).getOuterCall();
            Intrinsics.checkExpressionValueIsNotNull(call6, "call.outerCall");
            Call outerCall = call6;
            if (CallResolverUtilKt.isConventionCall(outerCall) || OperatorCallChecker.Companion.isWrongCallWithExplicitTypeArguments((VariableAsFunctionResolvedCall)((Object)resolvedCall2), outerCall)) {
                throw (Throwable)((Object)new AssertionError((Object)("Illegal resolved call to variable with invoke for " + outerCall + ". " + "Variable: " + ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getResultingDescriptor() + "Invoke: " + ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getFunctionCall().getResultingDescriptor())));
            }
        }
        if (call5.getCallElement() instanceof KtDestructuringDeclarationEntry || call5 instanceof CallTransformer.CallForImplicitInvoke) {
            if (!functionDescriptor2.isOperator()) {
                Companion.report(reportOn, functionDescriptor2, context2.getTrace());
            }
            return;
        }
        boolean bl = isConventionOperator = element instanceof KtOperationReferenceExpression && ((KtOperationReferenceExpression)element).isConventionOperator();
        if (isConventionOperator) {
            OperatorCallCheckerKt.access$checkModConvention(functionDescriptor2, context2.getLanguageVersionSettings(), context2.getTrace(), reportOn);
        }
        if ((isConventionOperator || element instanceof KtArrayAccessExpression) && !functionDescriptor2.isOperator()) {
            Companion.report(reportOn, functionDescriptor2, context2.getTrace());
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/OperatorCallChecker$Companion;", "", "()V", "checkNotErrorOrDynamic", "", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "isWrongCallWithExplicitTypeArguments", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/VariableAsFunctionResolvedCall;", "outerCall", "Lorg/jetbrains/kotlin/psi/Call;", "report", "", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "descriptor", "sink", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "frontend"})
    public static final class Companion {
        public final void report(@NotNull PsiElement reportOn, @NotNull FunctionDescriptor descriptor2, @NotNull DiagnosticSink sink) {
            Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(sink, "sink");
            if (!this.checkNotErrorOrDynamic(descriptor2)) {
                return;
            }
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "descriptor.containingDeclaration");
            DeclarationDescriptor containingDeclaration = declarationDescriptor;
            String string = DescriptorUtilsKt.getFqNameUnsafe(containingDeclaration).asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "containingDeclaration.fqNameUnsafe.asString()");
            String containingDeclarationName = string;
            sink.report(Errors.OPERATOR_MODIFIER_REQUIRED.on(reportOn, descriptor2, containingDeclarationName));
        }

        private final boolean checkNotErrorOrDynamic(FunctionDescriptor functionDescriptor) {
            return !DynamicCallsKt.isDynamic(functionDescriptor) && !ErrorUtils.isError(functionDescriptor);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isWrongCallWithExplicitTypeArguments(VariableAsFunctionResolvedCall resolvedCall2, Call outerCall) {
            List<KtTypeProjection> list2 = outerCall.getTypeArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, "outerCall.typeArguments");
            Collection collection = list2;
            boolean bl = false;
            if (collection.isEmpty()) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            FunctionDescriptor functionDescriptor = resolvedCall2.getFunctionCall().getCandidateDescriptor();
            Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "resolvedCall.functionCall.candidateDescriptor");
            List<TypeParameterDescriptor> list3 = functionDescriptor.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list3, "resolvedCall.functionCal\u2026Descriptor.typeParameters");
            collection = list3;
            bl = false;
            if (collection.isEmpty()) return false;
            boolean bl3 = true;
            if (!bl3) return false;
            boolean bl4 = true;
            boolean passedTypeArgumentsToInvoke = bl4;
            if (!passedTypeArgumentsToInvoke) return false;
            VariableDescriptor variableDescriptor = resolvedCall2.getVariableCall().getCandidateDescriptor();
            Intrinsics.checkExpressionValueIsNotNull(variableDescriptor, "resolvedCall.variableCall.candidateDescriptor");
            List<TypeParameterDescriptor> list4 = variableDescriptor.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list4, "resolvedCall.variableCal\u2026Descriptor.typeParameters");
            collection = list4;
            bl = false;
            if (collection.isEmpty()) return false;
            return true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

