/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.bindingContextUtil;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000j\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\n\u001a\u00020\u0007*\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u001a\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0014\u001a\u00020\u0015*\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0016\u001a\u00020\u0015*\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0017\u001a\u00020\u0015*\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004\u001a*\u0010\u0018\u001a\u00020\u0019\"\u000e\b\u0000\u0010\u001a*\b\u0012\u0004\u0012\u0002H\u001a0\u001b*\b\u0012\u0004\u0012\u0002H\u001a0\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000e\u001a\u001c\u0010\u001d\u001a\u00020\u0019*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"\u00a8\u0006#"}, d2={"getAbbreviatedTypeOrType", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "getDataFlowInfoAfter", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "position", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "getDataFlowInfoBefore", "getReferenceTargets", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getTargetFunction", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "getTargetFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "isUsedAsExpression", "", "isUsedAsResultOfLambda", "isUsedAsStatement", "recordDataFlowInfo", "", "C", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "expression", "recordScope", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "frontend"})
public final class BindingContextUtilsKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FunctionDescriptor getTargetFunctionDescriptor(@NotNull KtReturnExpression $this$getTargetFunctionDescriptor, @NotNull BindingContext context2) {
        void $this$getNonStrictParentOfType$iv;
        Intrinsics.checkParameterIsNotNull($this$getTargetFunctionDescriptor, "$this$getTargetFunctionDescriptor");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        KtSimpleNameExpression targetLabel = $this$getTargetFunctionDescriptor.getTargetLabel();
        if (targetLabel != null) {
            SimpleFunctionDescriptor simpleFunctionDescriptor;
            PsiElement psiElement = (PsiElement)context2.get(BindingContext.LABEL_TARGET, targetLabel);
            if (psiElement != null) {
                PsiElement psiElement2 = psiElement;
                boolean bl = false;
                boolean bl2 = false;
                PsiElement it = psiElement2;
                boolean bl3 = false;
                simpleFunctionDescriptor = (SimpleFunctionDescriptor)context2.get(BindingContext.FUNCTION, it);
            } else {
                simpleFunctionDescriptor = null;
            }
            return simpleFunctionDescriptor;
        }
        PsiElement psiElement = $this$getTargetFunctionDescriptor;
        ReadOnlySlice<PsiElement, DeclarationDescriptor> readOnlySlice = BindingContext.DECLARATION_TO_DESCRIPTOR;
        BindingContext bindingContext = context2;
        boolean $i$f$getNonStrictParentOfType = false;
        KtDeclarationWithBody ktDeclarationWithBody = PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtDeclarationWithBody.class, false);
        DeclarationDescriptor declarationDescriptor = bindingContext.get(readOnlySlice, ktDeclarationWithBody);
        FunctionDescriptor functionDescriptor = DescriptorUtils.getParentOfType(declarationDescriptor, FunctionDescriptor.class, false);
        if (functionDescriptor == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "DescriptorUtils.getParen\u2026e)\n        ?: return null");
        FunctionDescriptor containingFunctionDescriptor = functionDescriptor;
        return SequencesKt.firstOrNull(SequencesKt.dropWhile(SequencesKt.generateSequence(containingFunctionDescriptor, (Function1)getTargetFunctionDescriptor.2.INSTANCE), getTargetFunctionDescriptor.3.INSTANCE));
    }

    @Nullable
    public static final KtCallableDeclaration getTargetFunction(@NotNull KtReturnExpression $this$getTargetFunction, @NotNull BindingContext context2) {
        KtCallableDeclaration ktCallableDeclaration;
        Intrinsics.checkParameterIsNotNull($this$getTargetFunction, "$this$getTargetFunction");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        FunctionDescriptor functionDescriptor = BindingContextUtilsKt.getTargetFunctionDescriptor($this$getTargetFunction, context2);
        if (functionDescriptor != null) {
            FunctionDescriptor functionDescriptor2 = functionDescriptor;
            boolean bl = false;
            boolean bl2 = false;
            FunctionDescriptor it = functionDescriptor2;
            boolean bl3 = false;
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(it);
            if (!(psiElement instanceof KtCallableDeclaration)) {
                psiElement = null;
            }
            ktCallableDeclaration = (KtCallableDeclaration)psiElement;
        } else {
            ktCallableDeclaration = null;
        }
        return ktCallableDeclaration;
    }

    public static final boolean isUsedAsExpression(@NotNull KtExpression $this$isUsedAsExpression, @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull($this$isUsedAsExpression, "$this$isUsedAsExpression");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Object v = context2.get(BindingContext.USED_AS_EXPRESSION, $this$isUsedAsExpression);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)v;
    }

    public static final boolean isUsedAsResultOfLambda(@NotNull KtExpression $this$isUsedAsResultOfLambda, @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull($this$isUsedAsResultOfLambda, "$this$isUsedAsResultOfLambda");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Object v = context2.get(BindingContext.USED_AS_RESULT_OF_LAMBDA, $this$isUsedAsResultOfLambda);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)v;
    }

    public static final boolean isUsedAsStatement(@NotNull KtExpression $this$isUsedAsStatement, @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull($this$isUsedAsStatement, "$this$isUsedAsStatement");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        return !BindingContextUtilsKt.isUsedAsExpression($this$isUsedAsStatement, context2);
    }

    public static final <C extends ResolutionContext<C>> void recordDataFlowInfo(@NotNull ResolutionContext<C> $this$recordDataFlowInfo, @Nullable KtExpression expression2) {
        Intrinsics.checkParameterIsNotNull($this$recordDataFlowInfo, "$this$recordDataFlowInfo");
        if (expression2 == null) {
            return;
        }
        KotlinTypeInfo typeInfo = (KotlinTypeInfo)$this$recordDataFlowInfo.trace.get(BindingContext.EXPRESSION_TYPE_INFO, expression2);
        if (typeInfo != null) {
            BindingTrace bindingTrace = $this$recordDataFlowInfo.trace;
            DataFlowInfo dataFlowInfo = $this$recordDataFlowInfo.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression2, typeInfo.replaceDataFlowInfo(dataFlowInfo));
        } else if (Intrinsics.areEqual($this$recordDataFlowInfo.dataFlowInfo, DataFlowInfo.Companion.getEMPTY()) ^ true) {
            BindingTrace bindingTrace = $this$recordDataFlowInfo.trace;
            DataFlowInfo dataFlowInfo = $this$recordDataFlowInfo.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression2, TypeInfoFactoryKt.noTypeInfo(dataFlowInfo));
        }
    }

    public static final void recordScope(@NotNull BindingTrace $this$recordScope, @NotNull LexicalScope scope2, @Nullable KtElement element) {
        Intrinsics.checkParameterIsNotNull($this$recordScope, "$this$recordScope");
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        if (element != null) {
            HierarchicalScope hierarchicalScope = ScopeUtilsKt.takeSnapshot(scope2);
            if (hierarchicalScope == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.LexicalScope");
            }
            $this$recordScope.record(BindingContext.LEXICAL_SCOPE, element, (LexicalScope)hierarchicalScope);
        }
    }

    @NotNull
    public static final DataFlowInfo getDataFlowInfoAfter(@NotNull BindingContext $this$getDataFlowInfoAfter, @NotNull PsiElement position) {
        Intrinsics.checkParameterIsNotNull($this$getDataFlowInfoAfter, "$this$getDataFlowInfoAfter");
        Intrinsics.checkParameterIsNotNull(position, "position");
        Iterator<PsiElement> iterator2 = PsiUtilsKt.getParentsWithSelf(position).iterator();
        while (iterator2.hasNext()) {
            Object object;
            PsiElement element = iterator2.next();
            PsiElement psiElement = element;
            if (!(psiElement instanceof KtExpression)) {
                psiElement = null;
            }
            if ((object = (KtExpression)psiElement) == null) continue;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            PsiElement parent2 = it.getParent();
            KotlinTypeInfo kotlinTypeInfo = parent2 instanceof KtQualifiedExpression && Intrinsics.areEqual(it, ((KtQualifiedExpression)parent2).getSelectorExpression()) ? null : (KotlinTypeInfo)$this$getDataFlowInfoAfter.get(BindingContext.EXPRESSION_TYPE_INFO, it);
            object = kotlinTypeInfo;
            if (kotlinTypeInfo == null) continue;
            object2 = object;
            bl = false;
            bl2 = false;
            it = object2;
            boolean bl4 = false;
            return ((KotlinTypeInfo)it).getDataFlowInfo();
        }
        return DataFlowInfo.Companion.getEMPTY();
    }

    @NotNull
    public static final DataFlowInfo getDataFlowInfoBefore(@NotNull BindingContext $this$getDataFlowInfoBefore, @NotNull PsiElement position) {
        Intrinsics.checkParameterIsNotNull($this$getDataFlowInfoBefore, "$this$getDataFlowInfoBefore");
        Intrinsics.checkParameterIsNotNull(position, "position");
        Iterator<PsiElement> iterator2 = PsiUtilsKt.getParentsWithSelf(position).iterator();
        while (iterator2.hasNext()) {
            Object object;
            PsiElement element = iterator2.next();
            PsiElement psiElement = element;
            if (!(psiElement instanceof KtExpression)) {
                psiElement = null;
            }
            if ((object = (KtExpression)psiElement) == null) continue;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            object = (DataFlowInfo)$this$getDataFlowInfoBefore.get(BindingContext.DATA_FLOW_INFO_BEFORE, it);
            if (object == null) continue;
            object2 = object;
            bl = false;
            bl2 = false;
            it = object2;
            boolean bl4 = false;
            Object object3 = it;
            Intrinsics.checkExpressionValueIsNotNull(object3, "it");
            return object3;
        }
        return DataFlowInfo.Companion.getEMPTY();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Collection<DeclarationDescriptor> getReferenceTargets(@NotNull KtExpression $this$getReferenceTargets, @NotNull BindingContext context2) {
        Object object;
        boolean bl;
        Object object2;
        Intrinsics.checkParameterIsNotNull($this$getReferenceTargets, "$this$getReferenceTargets");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        DeclarationDescriptor targetDescriptor = $this$getReferenceTargets instanceof KtReferenceExpression ? (DeclarationDescriptor)context2.get(BindingContext.REFERENCE_TARGET, $this$getReferenceTargets) : null;
        List<DeclarationDescriptor> list2 = targetDescriptor;
        if (list2 != null) {
            object2 = list2;
            bl = false;
            boolean bl2 = false;
            DeclarationDescriptor it = object2;
            boolean bl3 = false;
            list2 = CollectionsKt.listOf(it);
            if (list2 != null) {
                object = list2;
                return object;
            }
        }
        object2 = (Collection)context2.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, $this$getReferenceTargets);
        bl = false;
        object = object2;
        if (object != null) {
            return object;
        }
        object = CollectionsKt.emptyList();
        return object;
    }

    @Nullable
    public static final KotlinType getAbbreviatedTypeOrType(@NotNull KtTypeReference $this$getAbbreviatedTypeOrType, @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull($this$getAbbreviatedTypeOrType, "$this$getAbbreviatedTypeOrType");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        KotlinType kotlinType2 = (KotlinType)context2.get(BindingContext.ABBREVIATED_TYPE, $this$getAbbreviatedTypeOrType);
        if (kotlinType2 == null) {
            kotlinType2 = (KotlinType)context2.get(BindingContext.TYPE, $this$getAbbreviatedTypeOrType);
        }
        return kotlinType2;
    }

    @Nullable
    public static final KotlinType getAbbreviatedTypeOrType(@NotNull KtTypeElement $this$getAbbreviatedTypeOrType, @NotNull BindingContext context2) {
        KotlinType kotlinType2;
        Intrinsics.checkParameterIsNotNull($this$getAbbreviatedTypeOrType, "$this$getAbbreviatedTypeOrType");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        PsiElement parent2 = $this$getAbbreviatedTypeOrType.getParent();
        if (parent2 instanceof KtTypeReference) {
            kotlinType2 = BindingContextUtilsKt.getAbbreviatedTypeOrType((KtTypeReference)parent2, context2);
        } else if (parent2 instanceof KtNullableType) {
            KotlinType outerType = BindingContextUtilsKt.getAbbreviatedTypeOrType((KtTypeElement)parent2, context2);
            if ($this$getAbbreviatedTypeOrType instanceof KtNullableType) {
                kotlinType2 = outerType;
            } else {
                KotlinType kotlinType3 = outerType;
                kotlinType2 = kotlinType3 != null ? TypeUtilsKt.makeNotNullable(kotlinType3) : null;
            }
        } else {
            kotlinType2 = null;
        }
        return kotlinType2;
    }
}

