/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonCoroutineCodegenUtilKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CoroutineLanguageVersionSettingsUtilKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.metadata.CoroutineMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.expression.ExpressionVisitor;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsicWithReceiverComputed;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.LambdaArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentUnmapped;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.checkers.PrimitiveNumericComparisonInfo;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0096\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u001a&\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f\u001a@\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001\u001a\u0018\u0010\u001c\u001a\u00020\u000f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0016\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\"\u0010%\u001a\u00020&*\u00020\u00182\u0006\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020*\u001a\u001a\u0010+\u001a\u00020\b*\u00020\u00182\u0006\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u000f\u001a\u001a\u0010+\u001a\u00020\b*\u00020\u00182\u0006\u0010\t\u001a\u00020\b2\u0006\u0010-\u001a\u00020\u000f\u001a\"\u0010.\u001a\u00020\u0006*\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u000f\u001a\u0016\u00100\u001a\u00020\u000f*\u00020\u00182\n\u00101\u001a\u0006\u0012\u0002\b\u00030\"\u001a\"\u00102\u001a\u00020&*\u0002032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u00142\u0006\u00104\u001a\u00020\u001a\u001a\u0014\u00105\u001a\u0004\u0018\u00010 *\u00020\u00182\u0006\u0010-\u001a\u000206\u001a\u0012\u00107\u001a\u00020 *\u00020\u00182\u0006\u0010-\u001a\u000206\u001a\u0014\u00108\u001a\u0004\u0018\u000109*\u00020\u00182\u0006\u0010-\u001a\u000206\u001a\n\u0010:\u001a\u00020\u001a*\u00020\u0014\u001a\n\u0010;\u001a\u00020\u001a*\u00020\u0014\u001a\n\u0010<\u001a\u00020 *\u00020 \u001aH\u0010=\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H?0\u0005\u0012\u0004\u0012\u0002H@0>0\u0005\"\u0004\b\u0000\u0010?\"\u0004\b\u0001\u0010@*\b\u0012\u0004\u0012\u0002H?0\u00052\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u0002H?\u0012\u0004\u0012\u0002H@0B\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006C"}, d2={"finalElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "getFinalElement", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "createPrototypeStatements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "superName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "name", "definePackageAlias", "", "varName", "tag", "parentRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "generateDelegateCall", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "fromDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "toDescriptor", "thisObject", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "detectDefaultParameters", "", "source", "getReferenceToJsClass", "classifierDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "resolveAccessorCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "suspendPropertyDescriptor", "addAccessorsToPrototype", "", "containingClass", "propertyDescriptor", "literal", "Lorg/jetbrains/kotlin/js/backend/ast/JsObjectLiteral;", "addFunctionButNotExport", "descriptor", "expression", "addFunctionToPrototype", "function", "createCoroutineResult", "resolvedCall", "fillCoroutineMetadata", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "hasController", "getPrecisePrimitiveType", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getPrecisePrimitiveTypeNotNull", "getPrimitiveNumericComparisonInfo", "Lorg/jetbrains/kotlin/resolve/checkers/PrimitiveNumericComparisonInfo;", "hasOrInheritsParametersWithDefaultValue", "hasOwnParametersWithDefaultValue", "refineType", "splitToRanges", "Lkotlin/Pair;", "T", "S", "classifier", "Lkotlin/Function1;", "js.translator"})
public final class UtilsKt {
    @NotNull
    public static final JsStatement generateDelegateCall(@NotNull ClassDescriptor classDescriptor2, @NotNull FunctionDescriptor fromDescriptor, @NotNull FunctionDescriptor toDescriptor, @NotNull JsExpression thisObject, @NotNull TranslationContext context2, boolean detectDefaultParameters, @Nullable PsiElement source) {
        List<ValueParameterDescriptor> list2;
        Intrinsics.checkParameterIsNotNull(classDescriptor2, "classDescriptor");
        Intrinsics.checkParameterIsNotNull(fromDescriptor, "fromDescriptor");
        Intrinsics.checkParameterIsNotNull(toDescriptor, "toDescriptor");
        Intrinsics.checkParameterIsNotNull(thisObject, "thisObject");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Function1<FunctionDescriptor, JsName> $fun$getNameForFunctionWithPossibleDefaultParam$1 = new Function1<FunctionDescriptor, JsName>(detectDefaultParameters, context2){
            final /* synthetic */ boolean $detectDefaultParameters;
            final /* synthetic */ TranslationContext $context;

            @NotNull
            public final JsName invoke(@NotNull FunctionDescriptor $this$getNameForFunctionWithPossibleDefaultParam) {
                JsName jsName;
                Intrinsics.checkParameterIsNotNull($this$getNameForFunctionWithPossibleDefaultParam, "$this$getNameForFunctionWithPossibleDefaultParam");
                if (this.$detectDefaultParameters && UtilsKt.hasOrInheritsParametersWithDefaultValue($this$getNameForFunctionWithPossibleDefaultParam)) {
                    JsScope jsScope = this.$context.scope();
                    StringBuilder stringBuilder = new StringBuilder();
                    JsName jsName2 = this.$context.getNameForDescriptor($this$getNameForFunctionWithPossibleDefaultParam);
                    Intrinsics.checkExpressionValueIsNotNull(jsName2, "context.getNameForDescriptor(this)");
                    jsName = jsScope.declareName(stringBuilder.append(jsName2.getIdent()).append("$default").toString());
                } else {
                    jsName = this.$context.getNameForDescriptor($this$getNameForFunctionWithPossibleDefaultParam);
                }
                Intrinsics.checkExpressionValueIsNotNull(jsName, "if (detectDefaultParamet\u2026escriptor(this)\n        }");
                return jsName;
            }
            {
                this.$detectDefaultParameters = bl;
                this.$context = translationContext;
                super(1);
            }
        };
        JsName overriddenMemberFunctionName = $fun$getNameForFunctionWithPossibleDefaultParam$1.invoke(toDescriptor);
        JsNameRef overriddenMemberFunctionRef = new JsNameRef(overriddenMemberFunctionName, thisObject);
        SmartList<JsParameter> parameters2 = new SmartList<JsParameter>();
        SmartList<JsNameRef> args2 = new SmartList<JsNameRef>();
        if (DescriptorUtils.isExtension(fromDescriptor)) {
            JsName jsName = JsScope.declareTemporaryName(Namer.getReceiverParameterName());
            Intrinsics.checkExpressionValueIsNotNull(jsName, "JsScope.declareTemporary\u2026tReceiverParameterName())");
            JsName extensionFunctionReceiverName = jsName;
            parameters2.add(new JsParameter(extensionFunctionReceiverName));
            args2.add(new JsNameRef(extensionFunctionReceiverName));
        }
        if (fromDescriptor.isSuspend()) {
            List<ValueParameterDescriptor> list3 = fromDescriptor.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list3, "fromDescriptor.valueParameters");
            Collection collection = list3;
            ValueParameterDescriptor valueParameterDescriptor = context2.getContinuationParameterDescriptor();
            if (valueParameterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            list2 = CollectionsKt.plus(collection, valueParameterDescriptor);
        } else {
            List<ValueParameterDescriptor> list4 = fromDescriptor.getValueParameters();
            list2 = list4;
            Intrinsics.checkExpressionValueIsNotNull(list4, "fromDescriptor.valueParameters");
        }
        List<ValueParameterDescriptor> valueParameterDescriptors = list2;
        Iterator<ValueParameterDescriptor> iterator2 = valueParameterDescriptors.iterator();
        while (iterator2.hasNext()) {
            JsName jsParamName;
            String paramName;
            ValueParameterDescriptor param;
            ValueParameterDescriptor valueParameterDescriptor = param = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "param");
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor.getName().asString(), "param.name.asString()");
            Intrinsics.checkExpressionValueIsNotNull(JsScope.declareTemporaryName(paramName), "JsScope.declareTemporaryName(paramName)");
            parameters2.add(new JsParameter(jsParamName));
            args2.add(new JsNameRef(jsParamName));
        }
        FunctionIntrinsic intrinsic = context2.intrinsics().getFunctionIntrinsic(toDescriptor, context2);
        JsExpression invocation = intrinsic instanceof FunctionIntrinsicWithReceiverComputed ? ((FunctionIntrinsicWithReceiverComputed)intrinsic).apply(thisObject, (List<? extends JsExpression>)args2, context2) : (JsExpression)new JsInvocation((JsExpression)overriddenMemberFunctionRef, (List<? extends JsExpression>)args2);
        invocation.setSource(source);
        JsFunction jsFunction = TranslationUtils.simpleReturnFunction(context2.scope(), invocation);
        Intrinsics.checkExpressionValueIsNotNull(jsFunction, "simpleReturnFunction(context.scope(), invocation)");
        JsFunction functionObject = jsFunction;
        PsiElement psiElement = source;
        functionObject.setSource(psiElement != null ? UtilsKt.getFinalElement(psiElement) : null);
        functionObject.getParameters().addAll((Collection<JsParameter>)parameters2);
        if (MetadataProperties.isSuspend(functionObject)) {
            UtilsKt.fillCoroutineMetadata(functionObject, context2, fromDescriptor, false);
        }
        JsName fromFunctionName = $fun$getNameForFunctionWithPossibleDefaultParam$1.invoke(fromDescriptor);
        JsExpression jsExpression = JsAstUtils.prototypeOf(context2.getInnerReference(classDescriptor2));
        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "JsAstUtils.prototypeOf(c\u2026ference(classDescriptor))");
        JsExpression prototypeRef = jsExpression;
        JsNameRef functionRef = new JsNameRef(fromFunctionName, prototypeRef);
        JsStatement jsStatement = JsAstUtils.assignment(functionRef, functionObject).makeStmt();
        Intrinsics.checkExpressionValueIsNotNull(jsStatement, "JsAstUtils.assignment(fu\u2026unctionObject).makeStmt()");
        return jsStatement;
    }

    @NotNull
    public static final <T, S> List<Pair<List<T>, S>> splitToRanges(@NotNull List<? extends T> $this$splitToRanges, @NotNull Function1<? super T, ? extends S> classifier2) {
        Intrinsics.checkParameterIsNotNull($this$splitToRanges, "$this$splitToRanges");
        Intrinsics.checkParameterIsNotNull(classifier2, "classifier");
        if ($this$splitToRanges.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        int lastIndex = 0;
        S lastClass = classifier2.invoke($this$splitToRanges.get(0));
        boolean bl = false;
        List result2 = new ArrayList();
        Object object = SequencesKt.drop(SequencesKt.withIndex(CollectionsKt.asSequence((Iterable)$this$splitToRanges)), 1).iterator();
        while (object.hasNext()) {
            IndexedValue indexedValue = object.next();
            int index2 = indexedValue.component1();
            Object e = indexedValue.component2();
            S cls = classifier2.invoke(e);
            if (!(Intrinsics.areEqual(cls, lastClass) ^ true)) continue;
            Collection collection = result2;
            Pair<List<? extends T>, S> pair = new Pair<List<? extends T>, S>($this$splitToRanges.subList(lastIndex, index2), lastClass);
            boolean bl2 = false;
            collection.add(pair);
            lastClass = cls;
            lastIndex = index2;
        }
        Collection collection = result2;
        object = new Pair<List<? extends T>, S>($this$splitToRanges.subList(lastIndex, $this$splitToRanges.size()), lastClass);
        boolean bl3 = false;
        collection.add(object);
        return result2;
    }

    @NotNull
    public static final JsExpression getReferenceToJsClass(@NotNull KotlinType type2, @NotNull TranslationContext context2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        return UtilsKt.getReferenceToJsClass(type2.getConstructor().getDeclarationDescriptor(), context2);
    }

    @NotNull
    public static final JsExpression getReferenceToJsClass(@Nullable ClassifierDescriptor classifierDescriptor, @NotNull TranslationContext context2) {
        boolean bl;
        boolean bl2;
        JsExpression jsExpression;
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Object object = classifierDescriptor;
        if (object instanceof ClassDescriptor) {
            jsExpression = ReferenceTranslator.translateAsTypeReference((ClassDescriptor)classifierDescriptor, context2);
        } else if (object instanceof TypeParameterDescriptor) {
            bl2 = ((TypeParameterDescriptor)classifierDescriptor).isReified();
            bl = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            UsageTracker usageTracker = context2.usageTracker();
            if (usageTracker != null) {
                usageTracker.used(classifierDescriptor);
            }
            if ((jsExpression = context2.captureTypeIfNeedAndGetCapturedName((TypeParameterDescriptor)classifierDescriptor)) == null) {
                jsExpression = context2.getNameForDescriptor(classifierDescriptor).makeRef();
            }
        } else {
            throw (Throwable)new IllegalStateException("Can't get reference for " + classifierDescriptor);
        }
        object = jsExpression;
        bl2 = false;
        bl = false;
        Object it = object;
        boolean bl5 = false;
        Object object2 = it;
        Intrinsics.checkExpressionValueIsNotNull(object2, "it");
        MetadataProperties.setPrimitiveKClass((JsExpression)object2, ExpressionVisitor.getPrimitiveClass(context2, classifierDescriptor));
        Object object3 = object;
        Intrinsics.checkExpressionValueIsNotNull(object3, "when (classifierDescript\u2026assifierDescriptor)\n    }");
        return object3;
    }

    @NotNull
    public static final JsStatement addFunctionToPrototype(@NotNull TranslationContext $this$addFunctionToPrototype, @NotNull ClassDescriptor classDescriptor2, @NotNull FunctionDescriptor descriptor2, @NotNull JsExpression function2) {
        Intrinsics.checkParameterIsNotNull($this$addFunctionToPrototype, "$this$addFunctionToPrototype");
        Intrinsics.checkParameterIsNotNull(classDescriptor2, "classDescriptor");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(function2, "function");
        JsExpression jsExpression = JsAstUtils.prototypeOf($this$addFunctionToPrototype.getInnerReference(classDescriptor2));
        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "JsAstUtils.prototypeOf(g\u2026ference(classDescriptor))");
        JsExpression prototypeRef = jsExpression;
        JsNameRef functionRef = new JsNameRef($this$addFunctionToPrototype.getNameForDescriptor(descriptor2), prototypeRef);
        JsStatement jsStatement = JsAstUtils.assignment(functionRef, function2).makeStmt();
        Intrinsics.checkExpressionValueIsNotNull(jsStatement, "JsAstUtils.assignment(fu\u2026Ref, function).makeStmt()");
        return jsStatement;
    }

    public static final void addAccessorsToPrototype(@NotNull TranslationContext $this$addAccessorsToPrototype, @NotNull ClassDescriptor containingClass, @NotNull PropertyDescriptor propertyDescriptor2, @NotNull JsObjectLiteral literal) {
        Intrinsics.checkParameterIsNotNull($this$addAccessorsToPrototype, "$this$addAccessorsToPrototype");
        Intrinsics.checkParameterIsNotNull(containingClass, "containingClass");
        Intrinsics.checkParameterIsNotNull(propertyDescriptor2, "propertyDescriptor");
        Intrinsics.checkParameterIsNotNull(literal, "literal");
        JsExpression jsExpression = JsAstUtils.prototypeOf($this$addAccessorsToPrototype.getInnerReference(containingClass));
        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "JsAstUtils.prototypeOf(g\u2026ference(containingClass))");
        JsExpression prototypeRef = jsExpression;
        JsName jsName = $this$addAccessorsToPrototype.getNameForDescriptor(propertyDescriptor2);
        Intrinsics.checkExpressionValueIsNotNull(jsName, "getNameForDescriptor(propertyDescriptor)");
        JsName propertyName = jsName;
        JsInvocation jsInvocation = JsAstUtils.defineProperty(prototypeRef, propertyName.getIdent(), literal);
        Intrinsics.checkExpressionValueIsNotNull(jsInvocation, "JsAstUtils.definePropert\u2026pertyName.ident, literal)");
        JsInvocation defineProperty2 = jsInvocation;
        $this$addAccessorsToPrototype.addDeclarationStatement(defineProperty2.makeStmt());
    }

    public static final void fillCoroutineMetadata(@NotNull JsFunction $this$fillCoroutineMetadata, @NotNull TranslationContext context2, @NotNull FunctionDescriptor descriptor2, boolean hasController) {
        Intrinsics.checkParameterIsNotNull($this$fillCoroutineMetadata, "$this$fillCoroutineMetadata");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        ModuleDescriptor moduleDescriptor = context2.getCurrentModule();
        LanguageVersionSettings languageVersionSettings = context2.getLanguageVersionSettings();
        Intrinsics.checkExpressionValueIsNotNull(languageVersionSettings, "context.languageVersionSettings");
        PropertyDescriptor suspendPropertyDescriptor = (PropertyDescriptor)CollectionsKt.first((Iterable)moduleDescriptor.getPackage(CoroutineLanguageVersionSettingsUtilKt.coroutinesIntrinsicsPackageFqName(languageVersionSettings)).getMemberScope().getContributedVariables(CommonCoroutineCodegenUtilKt.getCOROUTINE_SUSPENDED_NAME(), NoLookupLocation.FROM_BACKEND));
        Function1<String, JsName> $fun$getCoroutinePropertyName$1 = new Function1<String, JsName>(context2){
            final /* synthetic */ TranslationContext $context;

            @NotNull
            public final JsName invoke(@NotNull String id) {
                Intrinsics.checkParameterIsNotNull(id, "id");
                JsName jsName = this.$context.getNameForDescriptor(TranslationUtils.getCoroutineProperty(this.$context, id));
                Intrinsics.checkExpressionValueIsNotNull(jsName, "context.getNameForDescri\u2026ineProperty(context, id))");
                return jsName;
            }
            {
                this.$context = translationContext;
                super(1);
            }
        };
        JsExpression suspendObject = CallTranslator.INSTANCE.translateGet(context2, UtilsKt.resolveAccessorCall(suspendPropertyDescriptor, context2), null);
        JsName jsName = context2.getNameForDescriptor(TranslationUtils.getCoroutineDoResumeFunction(context2));
        Intrinsics.checkExpressionValueIsNotNull(jsName, "context.getNameForDescri\u2026oResumeFunction(context))");
        JsExpression jsExpression = ReferenceTranslator.translateAsTypeReference(TranslationUtils.getCoroutineBaseClass(context2), context2);
        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "ReferenceTranslator.tran\u2026eClass(context), context)");
        JsName jsName2 = $fun$getCoroutinePropertyName$1.invoke("state");
        JsName jsName3 = $fun$getCoroutinePropertyName$1.invoke("exceptionState");
        JsName jsName4 = $fun$getCoroutinePropertyName$1.invoke("finallyPath");
        JsName jsName5 = $fun$getCoroutinePropertyName$1.invoke("result");
        JsName jsName6 = $fun$getCoroutinePropertyName$1.invoke("exception");
        boolean bl = descriptor2.getDispatchReceiverParameter() != null;
        SourceElement sourceElement = descriptor2.getSource();
        Intrinsics.checkExpressionValueIsNotNull(sourceElement, "descriptor.source");
        PsiElement psiElement = KotlinSourceElementKt.getPsi(sourceElement);
        boolean bl2 = bl;
        boolean bl3 = hasController;
        JsName jsName7 = jsName6;
        JsName jsName8 = jsName5;
        JsName jsName9 = jsName4;
        JsName jsName10 = jsName3;
        JsName jsName11 = jsName2;
        JsExpression jsExpression2 = jsExpression;
        JsExpression jsExpression3 = suspendObject;
        MetadataProperties.setCoroutineMetadata($this$fillCoroutineMetadata, new CoroutineMetadata(jsName, jsName11, jsName10, jsName9, jsName8, jsName7, jsExpression2, jsExpression3, bl3, bl2, psiElement));
    }

    private static final ResolvedCall<PropertyDescriptor> resolveAccessorCall(PropertyDescriptor suspendPropertyDescriptor, TranslationContext context2) {
        return new ResolvedCall<PropertyDescriptor>(context2, suspendPropertyDescriptor){
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ PropertyDescriptor $suspendPropertyDescriptor;

            @NotNull
            public ResolutionStatus getStatus() {
                return ResolutionStatus.SUCCESS;
            }

            @NotNull
            public Call getCall() {
                return new Call(this){
                    final /* synthetic */ resolveAccessorCall.1 this$0;

                    @Nullable
                    public ASTNode getCallOperationNode() {
                        return null;
                    }

                    @Nullable
                    public Receiver getExplicitReceiver() {
                        return null;
                    }

                    @Nullable
                    public ReceiverValue getDispatchReceiver() {
                        return null;
                    }

                    @Nullable
                    public KtExpression getCalleeExpression() {
                        return null;
                    }

                    @Nullable
                    public KtValueArgumentList getValueArgumentList() {
                        return null;
                    }

                    @NotNull
                    public List<ValueArgument> getValueArguments() {
                        return CollectionsKt.emptyList();
                    }

                    @NotNull
                    public List<LambdaArgument> getFunctionLiteralArguments() {
                        return CollectionsKt.emptyList();
                    }

                    @NotNull
                    public List<KtTypeProjection> getTypeArguments() {
                        return CollectionsKt.emptyList();
                    }

                    @Nullable
                    public KtTypeArgumentList getTypeArgumentList() {
                        return null;
                    }

                    @NotNull
                    public KtElement getCallElement() {
                        JsConfig jsConfig = this.this$0.$context.getConfig();
                        Intrinsics.checkExpressionValueIsNotNull(jsConfig, "context.config");
                        Project project = jsConfig.getProject();
                        Intrinsics.checkExpressionValueIsNotNull(project, "context.config.project");
                        return new KtPsiFactory(project, false, 2, null).createExpression("COROUTINE_SUSPENDED");
                    }

                    @NotNull
                    public Call.CallType getCallType() {
                        return Call.CallType.DEFAULT;
                    }
                    {
                        this.this$0 = $outer;
                    }
                };
            }

            @NotNull
            public PropertyDescriptor getCandidateDescriptor() {
                return this.$suspendPropertyDescriptor;
            }

            @NotNull
            public PropertyDescriptor getResultingDescriptor() {
                return this.$suspendPropertyDescriptor;
            }

            @Nullable
            public Void getExtensionReceiver() {
                return null;
            }

            @Nullable
            public Void getDispatchReceiver() {
                return null;
            }

            @NotNull
            public ExplicitReceiverKind getExplicitReceiverKind() {
                return ExplicitReceiverKind.NO_EXPLICIT_RECEIVER;
            }

            @NotNull
            public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
                boolean bl = false;
                return new LinkedHashMap<K, V>();
            }

            @NotNull
            public List<ResolvedValueArgument> getValueArgumentsByIndex() {
                boolean bl = false;
                return new ArrayList<E>();
            }

            @NotNull
            public ArgumentUnmapped getArgumentMapping(@NotNull ValueArgument valueArgument) {
                Intrinsics.checkParameterIsNotNull(valueArgument, "valueArgument");
                return ArgumentUnmapped.INSTANCE;
            }

            @NotNull
            public Map<TypeParameterDescriptor, KotlinType> getTypeArguments() {
                boolean bl = false;
                return new LinkedHashMap<K, V>();
            }

            @NotNull
            public DataFlowInfoForArguments getDataFlowInfoForArguments() {
                throw (Throwable)new IllegalStateException();
            }

            @Nullable
            public KotlinType getSmartCastDispatchReceiverType() {
                return null;
            }
            {
                this.$context = $captured_local_variable$0;
                this.$suspendPropertyDescriptor = $captured_local_variable$1;
            }
        };
    }

    @NotNull
    public static final JsStatement definePackageAlias(@NotNull String name2, @NotNull JsName varName, @NotNull String tag, @NotNull JsExpression parentRef) {
        Intrinsics.checkParameterIsNotNull(name2, "name");
        Intrinsics.checkParameterIsNotNull(varName, "varName");
        Intrinsics.checkParameterIsNotNull(tag, "tag");
        Intrinsics.checkParameterIsNotNull(parentRef, "parentRef");
        JsNameRef selfRef = new JsNameRef(name2, parentRef);
        JsBinaryOperation jsBinaryOperation = JsAstUtils.or(selfRef, JsAstUtils.assignment(selfRef.deepCopy(), new JsObjectLiteral(false)));
        Intrinsics.checkExpressionValueIsNotNull(jsBinaryOperation, "JsAstUtils.or(selfRef, J\u2026 JsObjectLiteral(false)))");
        JsBinaryOperation rhs = jsBinaryOperation;
        JsVars jsVars = JsAstUtils.newVar(varName, rhs);
        boolean bl = false;
        boolean bl2 = false;
        JsVars $this$apply = jsVars;
        boolean bl3 = false;
        MetadataProperties.setExportedPackage($this$apply, tag);
        JsVars jsVars2 = jsVars;
        Intrinsics.checkExpressionValueIsNotNull(jsVars2, "JsAstUtils.newVar(varNam\u2026{ exportedPackage = tag }");
        return jsVars2;
    }

    @NotNull
    public static final PsiElement getFinalElement(@NotNull PsiElement $this$finalElement) {
        PsiElement psiElement;
        Intrinsics.checkParameterIsNotNull($this$finalElement, "$this$finalElement");
        PsiElement psiElement2 = $this$finalElement;
        if (psiElement2 instanceof KtFunctionLiteral) {
            psiElement = ((KtFunctionLiteral)$this$finalElement).getRBrace();
            if (psiElement == null) {
                psiElement = $this$finalElement;
            }
        } else if (psiElement2 instanceof KtDeclarationWithBody) {
            PsiElement psiElement3 = ((KtDeclarationWithBody)$this$finalElement).getBodyBlockExpression();
            if (psiElement3 == null || (psiElement3 = psiElement3.getRBrace()) == null) {
                psiElement3 = psiElement = (PsiElement)((KtDeclarationWithBody)$this$finalElement).getBodyExpression();
            }
            if (psiElement3 == null) {
                psiElement = $this$finalElement;
            }
        } else if (psiElement2 instanceof KtLambdaExpression) {
            psiElement = ((KtLambdaExpression)$this$finalElement).getBodyExpression();
            if (psiElement == null || (psiElement = ((KtBlockExpression)psiElement).getRBrace()) == null) {
                psiElement = $this$finalElement;
            }
        } else {
            psiElement = $this$finalElement;
        }
        return psiElement;
    }

    @NotNull
    public static final JsName addFunctionButNotExport(@NotNull TranslationContext $this$addFunctionButNotExport, @NotNull FunctionDescriptor descriptor2, @NotNull JsExpression expression2) {
        Intrinsics.checkParameterIsNotNull($this$addFunctionButNotExport, "$this$addFunctionButNotExport");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        JsName jsName = $this$addFunctionButNotExport.getInnerNameForDescriptor(descriptor2);
        Intrinsics.checkExpressionValueIsNotNull(jsName, "getInnerNameForDescriptor(descriptor)");
        return UtilsKt.addFunctionButNotExport($this$addFunctionButNotExport, jsName, expression2);
    }

    @NotNull
    public static final JsName addFunctionButNotExport(@NotNull TranslationContext $this$addFunctionButNotExport, @NotNull JsName name2, @NotNull JsExpression expression2) {
        Intrinsics.checkParameterIsNotNull($this$addFunctionButNotExport, "$this$addFunctionButNotExport");
        Intrinsics.checkParameterIsNotNull(name2, "name");
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        JsExpression jsExpression = expression2;
        if (jsExpression instanceof JsFunction) {
            ((JsFunction)expression2).setName(name2);
            $this$addFunctionButNotExport.addDeclarationStatement(expression2.makeStmt());
        } else {
            $this$addFunctionButNotExport.addDeclarationStatement(JsAstUtils.newVar(name2, expression2));
        }
        return name2;
    }

    @NotNull
    public static final List<JsStatement> createPrototypeStatements(@NotNull JsName superName, @NotNull JsName name2) {
        Intrinsics.checkParameterIsNotNull(superName, "superName");
        Intrinsics.checkParameterIsNotNull(name2, "name");
        JsNameRef jsNameRef = superName.makeRef();
        Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "superName.makeRef()");
        JsNameRef superclassRef = jsNameRef;
        JsExpression jsExpression = JsAstUtils.prototypeOf(superclassRef);
        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "JsAstUtils.prototypeOf(superclassRef)");
        JsExpression superPrototype = jsExpression;
        JsInvocation superPrototypeInstance = new JsInvocation((JsExpression)new JsNameRef("create", "Object"), superPrototype);
        JsNameRef jsNameRef2 = name2.makeRef();
        Intrinsics.checkExpressionValueIsNotNull(jsNameRef2, "name.makeRef()");
        JsNameRef classRef = jsNameRef2;
        JsExpression jsExpression2 = JsAstUtils.prototypeOf(classRef);
        Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "JsAstUtils.prototypeOf(classRef)");
        JsExpression prototype = jsExpression2;
        JsStatement jsStatement = JsAstUtils.assignment(prototype, superPrototypeInstance).makeStmt();
        Intrinsics.checkExpressionValueIsNotNull(jsStatement, "JsAstUtils.assignment(pr\u2026otypeInstance).makeStmt()");
        JsStatement prototypeStatement = jsStatement;
        JsNameRef constructorRef = new JsNameRef("constructor", prototype.deepCopy());
        JsStatement jsStatement2 = JsAstUtils.assignment(constructorRef, classRef.deepCopy()).makeStmt();
        Intrinsics.checkExpressionValueIsNotNull(jsStatement2, "JsAstUtils.assignment(co\u2026ef.deepCopy()).makeStmt()");
        JsStatement constructorStatement = jsStatement2;
        return CollectionsKt.listOf(prototypeStatement, constructorStatement);
    }

    @NotNull
    public static final JsExpression createCoroutineResult(@NotNull TranslationContext $this$createCoroutineResult, @NotNull ResolvedCall<?> resolvedCall2) {
        Intrinsics.checkParameterIsNotNull($this$createCoroutineResult, "$this$createCoroutineResult");
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull(call2, "resolvedCall.call");
        KtElement ktElement = call2.getCallElement();
        Intrinsics.checkExpressionValueIsNotNull(ktElement, "resolvedCall.call.callElement");
        KtElement callElement = ktElement;
        JsExpression coroutineRef = TranslationUtils.translateContinuationArgument($this$createCoroutineResult).source(callElement);
        JsNameRef jsNameRef = new JsNameRef("$$coroutineResult$$", coroutineRef);
        boolean bl = false;
        boolean bl2 = false;
        JsNameRef $this$apply = jsNameRef;
        boolean bl3 = false;
        MetadataProperties.setSideEffects($this$apply, SideEffectKind.DEPENDS_ON_STATE);
        $this$apply.setSource(callElement);
        MetadataProperties.setCoroutineResult($this$apply, true);
        MetadataProperties.setSynthetic($this$apply, true);
        return jsNameRef;
    }

    @NotNull
    public static final KotlinType refineType(@NotNull KotlinType $this$refineType) {
        KotlinType kotlinType2;
        Object v1;
        block2: {
            Intrinsics.checkParameterIsNotNull($this$refineType, "$this$refineType");
            Set<KotlinType> set = TypeUtils.getAllSupertypes($this$refineType);
            Intrinsics.checkExpressionValueIsNotNull(set, "TypeUtils.getAllSupertypes(this)");
            Iterable iterable = set;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                KotlinType p1 = (KotlinType)t;
                boolean bl3 = false;
                if (!KotlinBuiltIns.isPrimitiveTypeOrNullablePrimitiveType(p1)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        if ((kotlinType2 = (KotlinType)v1) == null) {
            kotlinType2 = $this$refineType;
        }
        return kotlinType2;
    }

    @Nullable
    public static final KotlinType getPrecisePrimitiveType(@NotNull TranslationContext $this$getPrecisePrimitiveType, @NotNull KtExpression expression2) {
        Intrinsics.checkParameterIsNotNull($this$getPrecisePrimitiveType, "$this$getPrecisePrimitiveType");
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        BindingContext bindingContext = $this$getPrecisePrimitiveType.bindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "bindingContext()");
        BindingContext bindingContext2 = bindingContext;
        KotlinType kotlinType2 = bindingContext2.getType(expression2);
        if (kotlinType2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "bindingContext.getType(expression) ?: return null");
        KotlinType ktType2 = kotlinType2;
        return UtilsKt.refineType(ktType2);
    }

    @NotNull
    public static final KotlinType getPrecisePrimitiveTypeNotNull(@NotNull TranslationContext $this$getPrecisePrimitiveTypeNotNull, @NotNull KtExpression expression2) {
        Intrinsics.checkParameterIsNotNull($this$getPrecisePrimitiveTypeNotNull, "$this$getPrecisePrimitiveTypeNotNull");
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        KotlinType kotlinType2 = UtilsKt.getPrecisePrimitiveType($this$getPrecisePrimitiveTypeNotNull, expression2);
        if (kotlinType2 == null) {
            throw (Throwable)new IllegalStateException("Type must be not null for " + expression2);
        }
        return kotlinType2;
    }

    @Nullable
    public static final PrimitiveNumericComparisonInfo getPrimitiveNumericComparisonInfo(@NotNull TranslationContext $this$getPrimitiveNumericComparisonInfo, @NotNull KtExpression expression2) {
        Intrinsics.checkParameterIsNotNull($this$getPrimitiveNumericComparisonInfo, "$this$getPrimitiveNumericComparisonInfo");
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        JsConfig jsConfig = $this$getPrimitiveNumericComparisonInfo.getConfig();
        Intrinsics.checkExpressionValueIsNotNull(jsConfig, "config");
        CompilerConfiguration compilerConfiguration = jsConfig.getConfiguration();
        Intrinsics.checkExpressionValueIsNotNull(compilerConfiguration, "config.configuration");
        LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(compilerConfiguration);
        boolean bl = false;
        boolean bl2 = false;
        LanguageVersionSettings it = languageVersionSettings;
        boolean bl3 = false;
        return it.supportsFeature(LanguageFeature.ProperIeee754Comparisons) ? (PrimitiveNumericComparisonInfo)$this$getPrimitiveNumericComparisonInfo.bindingContext().get(BindingContext.PRIMITIVE_NUMERIC_COMPARISON_INFO, expression2) : null;
    }

    public static final boolean hasOrInheritsParametersWithDefaultValue(@NotNull FunctionDescriptor $this$hasOrInheritsParametersWithDefaultValue) {
        Intrinsics.checkParameterIsNotNull($this$hasOrInheritsParametersWithDefaultValue, "$this$hasOrInheritsParametersWithDefaultValue");
        Boolean bl = DFS.ifAny((Collection)CollectionsKt.listOf($this$hasOrInheritsParametersWithDefaultValue), hasOrInheritsParametersWithDefaultValue.1.INSTANCE, hasOrInheritsParametersWithDefaultValue.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(bl, "DFS.ifAny(\n    listOf(th\u2026ersWithDefaultValue() }\n)");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasOwnParametersWithDefaultValue(@NotNull FunctionDescriptor $this$hasOwnParametersWithDefaultValue) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull($this$hasOwnParametersWithDefaultValue, "$this$hasOwnParametersWithDefaultValue");
        FunctionDescriptor functionDescriptor = $this$hasOwnParametersWithDefaultValue.getOriginal();
        Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "original");
        List<ValueParameterDescriptor> list2 = functionDescriptor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "original.valueParameters");
        Iterable $this$any$iv = list2;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            boolean bl2 = false;
            if (it.declaresDefaultValue()) return true;
            ValueParameterDescriptor valueParameterDescriptor = it;
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "it");
            if (ArgumentsUtilsKt.isActualParameterWithCorrespondingExpectedDefault(valueParameterDescriptor)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }
}

